<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentAdmissionApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_admission_applications', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('site_student_admission_declare_id');
            $table->string('transaction_number')->nullable();
            $table->string('board_roll_number')->nullable();
            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->string('father_name');
            $table->string('mother_name');
            $table->string('name_native_language')->nullable();
            $table->string('father_name_native_language')->nullable();
            $table->string('mother_name_native_language')->nullable();



            $table->integer('academic_group_id');
            $table->integer('academic_version_id');
            $table->integer('academic_shift_id');
            $table->integer('academic_year_id');
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id');
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_session_id')->nullable();


            $table->string('academic_subject_ids')->nullable();
            $table->string('optional_subject_ids')->nullable();
            $table->string('selective_markingless_subject_ids')->nullable();
            $table->string('compulsory_subject_ids')->nullable();
            $table->string('religion_subject_id')->nullable();
            $table->string('board_registration_number')->nullable();
            $table->string('academic_quata_id')->nullable();


            $table->string('unique_code');
            $table->integer('gender_id');
            $table->integer('religion_id');
            $table->integer('emergency_contact')->nullable();
            $table->integer('passport_no')->nullable();
            $table->integer('birth_certificate_no')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('student_image')->nullable();


            $table->string('email')->nullable();
            $table->string('student_contact_number')->nullable();
            $table->integer('blood_group_id')->nullable();

            $table->integer('father_occupation_id')->nullable();
            $table->integer('father_yearly_income')->nullable();
            $table->string('father_contact_number')->nullable();
            $table->string('father_email')->nullable();
            $table->integer('father_nid')->nullable();


            $table->integer('mother_occupation_id')->nullable();
            $table->integer('mother_yearly_income')->nullable();
            $table->string('mother_contact_number')->nullable();
            $table->string('mother_email')->nullable();
            $table->string('mother_nid')->nullable();



            $table->string('present_address_care_of')->nullable();
            $table->integer('present_country_id')->nullable();
            $table->integer('present_division_id')->nullable();
            $table->integer('present_district_id')->nullable();
            $table->integer('present_thana_id')->nullable();
            $table->integer('present_postoffice_id')->nullable();
            $table->integer('present_post_code')->nullable();
            $table->string('present_address')->nullable();


            $table->string('permanent_address_care_of')->nullable();
            $table->integer('permanent_country_id')->nullable();
            $table->integer('permanent_division_id')->nullable();
            $table->integer('permanent_district_id')->nullable();
            $table->integer('permanent_thana_id')->nullable();
            $table->integer('permanent_postoffice_id')->nullable();
            $table->integer('permanent_post_code')->nullable();
            $table->string('permanent_address')->nullable();

            $table->integer('previous_academic_class_id')->nullable();
            $table->integer('previous_roll_no')->nullable();
            $table->string('previous_gpa')->nullable();
            $table->integer('previous_exam_mark')->nullable();
            $table->string('previous_institute_name')->nullable();
            $table->string('previous_institute_location')->nullable();
            $table->string('tc_number')->nullable();
            $table->date('tc_date')->nullable();


            $table->string('local_guardian_name')->nullable();
            $table->integer('guardian_student_relation_id')->nullable();
            $table->string('local_gurdian_mobile')->nullable();
            $table->string('local_gurdian_address')->nullable();
            $table->string('local_gurdian_email')->nullable();



            $table->boolean('approve_as_student');
            $table->integer('site_id');
            $table->boolean('status')->default(true);
            $table->string('client_ip')->nullable();
            $table->timestamps();
        });



        Schema::create('site_student_admission_education_qualifications', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_admission_application_id');
            $table->integer('examination_id');
            $table->integer('board_roll_number')->nullable();
            $table->integer('board_registration_number')->nullable();
            $table->string('institution_name');
            $table->integer('academic_board_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('passing_year');
            $table->double('gpa_with_optional')->nullable();
            $table->double('gpa_without_optional')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_admission_applications');
    }
}
