<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAccountsVoucherDetailsBankAccountDepositRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_accounts_voucher_details_bank_account_deposit_records', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_accounts_voucher_detail_id')->nullable();
            $table->integer('site_accounts_bank_account_detail_id')->nullable();
            $table->decimal('deposit_amount',9,2)->nullable();
            $table->date('deposit_date')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_accounts_voucher_details_bank_account_deposit_records');
    }
}
