<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddOnlineExamStatusColumnToSiteExamRoutinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_exam_routines', function (Blueprint $table) {
            $table->boolean('online_exam_status')->default(false)->after('academic_exam_type_id');
        });


        Schema::table('site_exam_declare_student_subjects', function (Blueprint $table) {
            $table->boolean('online_exam_status')->default(false)->after('academic_exam_type_id');
            $table->boolean('online_exam_present_by_student')->default(false)->after('online_exam_status');
            $table->boolean('online_exam_start_by_teacher')->default(false)->after('online_exam_present_by_student');
            $table->boolean('online_exam_start')->default(false)->after('online_exam_start_by_teacher');
            $table->time('online_exam_start_time')->nullable()->after('online_exam_start');
            $table->boolean('online_exam_end')->default(false)->after('online_exam_start_time');
            $table->time('online_exam_end_time')->nullable()->after('online_exam_end');
            $table->boolean('online_exam_pause')->default(false)->after('online_exam_end_time');
            $table->time('online_exam_pause_time')->nullable()->after('online_exam_pause');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_exam_routines', function (Blueprint $table) {
            //
        });
    }
}
