<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSettocolumntolivemeetingtable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_live_meetings', function (Blueprint $table) {
            $table->text('sent_request')->after('duration')->nullable();
            $table->string('agenda')->after('topic')->nullable();
            $table->string('description')->after('topic')->nullable();
            $table->boolean('status')->default(1);

        });

        Schema::create('site_live_meeting_invitations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->nullable();
            $table->integer('routine_allocation_id')->nullable();
            $table->integer('meeting_id')->nullable();
            $table->date('date')->nullable();
            $table->string('user_activities')->nullable();

            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_live_meeting_invitations', function (Blueprint $table) {
            //
        });
    }
}
