<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddYearToSiteGroupSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_group_settings', function (Blueprint $table) {
            $table->string('academic_year_ids')->nullable()->after('academic_class_ids');
        });


        Schema::create('site_group_admission_declares', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('duration_from_date');
            $table->date('duration_to_date');
            $table->date('extended_date')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->string('academic_version_ids')->nullable();
            $table->string('academic_shift_ids')->nullable();
            $table->string('academic_year_ids')->nullable();
            $table->string('academic_department_ids')->nullable();
            $table->string('academic_class_ids')->nullable();
            $table->string('academic_session_ids')->nullable();
            $table->boolean('send_sms')->default(false)->nullable();
            $table->boolean('guardian_information_add')->default(false)->nullable();
            $table->boolean('address_information_add')->default(false)->nullable();
            $table->boolean('communication_information_add')->default(false)->nullable();
            $table->boolean('student_registration_number_box_show')->default(false)->nullable();
            $table->boolean('local_guardian_detail_information_add')->default(false)->nullable();
            $table->boolean('check_with_roll_number')->default(false)->nullable();
            $table->boolean('check_with_online_transaction_id')->default(false)->nullable();
            $table->boolean('check_with_board_university')->default(false)->nullable();
            $table->boolean('auto_roll_create_status')->default(false)->nullable();
            $table->boolean('bank_recipt_downlaod_status')->default(false)->nullable();
            $table->boolean('exam_passing_year_show')->default(false)->nullable();
            $table->string('education_qualification_ids')->nullable();
            $table->string('admission_form_language')->nullable();
            $table->integer('academic_payment_type_id')->nullable();
            $table->string('payment_company_ids')->nullable();
            $table->integer('auto_roll_digit')->nullable();
            $table->integer('passing_year_examination_id')->nullable();

            $table->boolean('form_number_entry_box_show')->default(false)->nullable();
            $table->boolean('form_number_check')->default(false)->nullable();
            $table->boolean('form_show_to_website')->default(true)->nullable();
            $table->boolean('site_can_not_approve_student')->default(false)->nullable();
            $table->integer('academic_admission_style_id')->nullable();
            $table->integer('site_group_id')->nullable();
            $table->boolean('status')->default(true);


            $table->timestamps();
        });




        Schema::table('site_student_admission_declares', function (Blueprint $table) {
            $table->boolean('form_number_entry_box_show')->default(false)->nullable();
            $table->boolean('form_number_check')->default(false)->nullable();
            $table->boolean('form_show_to_website')->default(true)->nullable();
            $table->boolean('site_can_not_approve_student')->default(false)->nullable();
            $table->integer('academic_admission_style_id')->nullable();
            $table->integer('site_group_admission_declare_id')->nullable();
            $table->integer('site_group_id')->nullable();
        });



        Schema::table('site_student_admission_applications', function (Blueprint $table) {
            $table->integer('menual_form_number')->nullable();
            $table->boolean('site_can_approve_student')->default(true);

        });



        Schema::table('academic_classes', function (Blueprint $table) {
            $table->date('minimum_birth_date')->nullable();

        });


        Schema::table('site_shift_class_group_section_settings', function (Blueprint $table) {
            $table->integer('admission_seat_capacity')->nullable();

        });



        Schema::create('academic_admission_styles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('name_key');
            $table->timestamps();

        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_group_settings', function (Blueprint $table) {
            //
        });
    }
}
