<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateQuizDeclareStudentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quiz_declare_students', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('quiz_declare_id');

            $table->bigInteger('student_history_id')->nullable();
            $table->bigInteger('student_question_ids')->nullable();
            $table->boolean('join_status')->default(0);
            $table->integer('total_question')->nullable();
            $table->integer('total_answer')->nullable();
            $table->integer('total_right_answer')->nullable();
            $table->integer('total_wrong_answer')->nullable();
            $table->string('quiz_time')->nullable();
            $table->integer('quiz_time_by_second')->nullable();
            $table->integer('rank')->nullable();
            $table->timestamps();

          //  $table->foreign('quiz_declare_id')->references('id')->on('quiz_declares')->onDelete('cascade');

        });
        Schema::table('quiz_declare_students', function($table) {
            $table->foreign('quiz_declare_id')->references('id')->on('quiz_declares')->onDelete('cascade')->onUpdate('cascade');;
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quiz_declare_students');
    }
}
