<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupSubjectGroupConditionSettingStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_subject_group_condition_setting_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('site_group_id');
            $table->bigInteger('academic_group_id');
            $table->bigInteger('academic_class_id');
            $table->bigInteger('academic_year_id');
            $table->bigInteger('academic_subject_id');
            $table->bigInteger('academic_department_id')->nullable();
            $table->string('academic_class_group_ids')->nullable();
            $table->string('academic_subject_condition_ids')->nullable();
            $table->integer('academic_subject_class_exam_condition_id')->nullable();
            $table->integer('exam_dependent_academic_subject_id')->nullable();
            $table->boolean('result_show_in_table_bellow')->default(false);
            $table->integer('subject_position')->nullable();
            $table->string('subject_code')->nullable();
           
            $table->text('note')->nullable();
            $table->boolean('status')->default(true);
            $table->bigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_subject_group_condition_setting_stores');
    }
}
