<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupShiftClassGroupSectionSettingStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_shift_class_group_section_setting_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('site_group_id');
            $table->integer('academic_version_id');
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_shift_id');
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id');
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->string('academic_section_ids')->nullable();
            $table->integer('seat_capacity')->nullable();
            $table->integer('admission_seat_capacity')->nullable();
            $table->integer('seat_extend')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
   
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_shift_class_group_section_setting_stores');
    }
}
