<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEduServiceChargeInSiteStudentAdmissionBoardApproves extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_admission_board_approves', function (Blueprint $table) {
            $table->boolean('edu_service_charge_percentage_status')->default(0);
            $table->string('edu_service_charge_amount')->nullable();
            $table->string('bank_service_charge_percentage')->nullable();
            $table->double('bank_service_charge_amount')->nullable();
        });

        Schema::table('site_student_fee_payment_histories', function (Blueprint $table) {
            $table->boolean('edu_service_charge_percentage_status')->default(0);
            $table->string('edu_service_charge')->nullable();
            $table->string('bank_service_charge_percentage')->nullable();
            $table->double('bank_service_charge_amount')->nullable();
        });

       
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_admission_board_approves', function (Blueprint $table) {
            //
        });
    }
}
