<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNewInSiteStudentTcSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_tc_settings', function (Blueprint $table) {
            $table->string('logo_position', 10);
            $table->boolean('border_image_status')->default(true);
            $table->string('border_image')->nullable();
            $table->boolean('watermark_status')->default(false);
            $table->string('watermark_image')->nullable();
            $table->string('referance_prefix', 10)->nullable();
            $table->integer('referance_number')->nullable();
            $table->string('referance_suffix', 10)->nullable();
            $table->boolean('session_show_status')->default(false);
            $table->string('tc_background_color')->nullable();
            $table->boolean('address_present_status')->default(true);
            $table->boolean('eiin_show_status')->default(false);
            $table->boolean('college_code_show_status')->default(false);
            $table->boolean('nu_code_show_status')->default(false);
            $table->boolean('status')->default(true);

            $table->text('des_part_1')->nullable();
            $table->text('des_part_2')->nullable();
            $table->text('des_part_3')->nullable();
            $table->text('des_part_4')->nullable();
            $table->text('des_part_5')->nullable();
            $table->text('des_part_6')->nullable();
            $table->text('des_part_7')->nullable();
            $table->text('des_part_8')->nullable();
            $table->text('des_part_9')->nullable();

            $table->string('academic_name_font')->nullable();
            $table->string('academic_address_font')->nullable();
            $table->string('title_font')->nullable();
            $table->string('ref_no_font')->nullable();
            $table->string('description_font')->nullable();
            $table->string('print_data_font')->nullable();
            $table->string('author_font')->nullable();

            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_tc_settings', function (Blueprint $table) {
            //
        });
    }
}
