<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHousesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('houses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->boolean('status')->default(1);
            $table->integer('position')->nullable();
            $table->timestamps();
        });
        Schema::table('student_histories', function (Blueprint $table) {
            $table->integer('house_id')->nullable();

        });
        Schema::table('users', function (Blueprint $table) {
            $table->integer('house_id')->nullable();
        });
        Schema::table('site_infos', function (Blueprint $table) {
            $table->string('house_ids')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('houses');
    }
}
