<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAssessmentExpertiseWiseTopicsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assessment_expertise_wise_topics', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_class_id');
            $table->integer('academic_subject_id');
            $table->integer('assessment_type_id');
            $table->integer('expertise_id');
            $table->string('topic_name');
            $table->string('topic_no')->nullable();
            $table->integer('serial')->nullable();
            $table->text('description')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
   
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assessment_expertise_wise_topics');
    }
}
