<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExpertiseAssessmentTypeAndTypeNoSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expertise_assessment_type_and_type_no_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_year_id');
            $table->integer('academic_class_id');
            $table->integer('assessment_id');
            $table->integer('academic_subject_id');
            $table->integer('expertise_id');
            $table->integer('topic_id');
            $table->integer('assessment_type_id');
            $table->integer('assessment_type_no_id');
            $table->integer('position_show');
            $table->boolean('status')->default(true);
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expertise_assessment_type_and_type_no_settings');
    }

}
