<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAssessmentResultScaleSystemSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assessment_result_scale_system_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_assessment_scale_id');
            $table->double('level_from')->nullable();
            $table->double('level_to')->nullable();
            $table->integer('graph_level')->nullable();
            $table->boolean('pass_fail_status')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assessment_result_scale_system_settings');
    }
}
