<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupExamDeclareStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_exam_declare_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('site_group_id');
            $table->integer('academic_version_id');
            $table->integer('academic_year_id');
            $table->integer('academic_shift_id');
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id');
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->string('site_subject_group_condition_setting_ids')->nullable();
            $table->integer('created_by')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_exam_declare_stores');
    }
}
