<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupExamRoutineStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_exam_routine_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('site_group_id');
            $table->integer('site_group_exam_declare_id')->nullable();
            $table->integer('site_group_site_subject_group_condition_setting_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->integer('academic_exam_type_id')->nullable();
            $table->boolean('online_exam_status')->default(false);
            $table->date('exam_start_date')->nullable();
            $table->date('exam_end_date')->nullable();
            $table->time('exam_start_time')->nullable();
            $table->time('exam_end_time')->nullable();
            $table->integer('exam_duration')->nullable();
            $table->integer('per_day_student')->nullable();
            $table->boolean('seat_plan_publish_for_employee')->default(false);
            $table->boolean('seat_plan_publish_for_student')->nullable(false);
            $table->boolean('status')->default(true);
            $table->timestamps();
        });

       
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_exam_routine_stores');
    }
}
