<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteEmployeeDutyHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_employee_duty_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('employee_history_id');
            $table->integer('academic_duty_type_id');
            $table->date('request_date');
            $table->date('from_date');
            $table->date('to_date');
            $table->string('reason', 300)->nullable();
            $table->string('duty_status')->default('pending');
            $table->boolean('status')->default(0);
            $table->integer('user_id');
            $table->integer('site_id');
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_employee_duty_histories');
    }

}
