<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentFineSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_fine_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->integer('fine_type_id')->nullable();
            $table->string('fine_amount_type')->default('round');
            $table->integer('fine_amount')->nullable();
            $table->integer('site_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_fine_settings');
    }
}
