<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteClassSubjectProgressAreasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_class_subject_progress_areas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_class_id');
            $table->integer('academic_subject_id');
            $table->text('subject_area');
            $table->integer('serial')->nullable();
            $table->text('description')->nullable();
            $table->boolean('status')->default(true);
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_class_subject_progress_areas');
    }
}
