import swal from 'sweetalert2';

export function handleAxiosError(error) {
    if (error.response && error.response.status === 422) {
        const errors = error.response.data.errors;

        let messages = [];
        for (let field in errors) {
            messages.push(...errors[field]);
        }

        swal({
            type: 'error',
            title: 'Validation Error',
            html: messages.join('<br>'),
            confirmButtonText: 'OK'
        });

        return errors;
    }
    else if (error.response && error.response.data && error.response.data.message) {
        swal({
            type: 'error',
            title: 'Error',
            text: error.response.data.message,
            confirmButtonText: 'OK'
        });
        console.error('Server error:', error.response.data.message);
    }
    else {
        swal({
            type: 'error',
            title: 'Error',
            text: 'Something went wrong. Please try again.',
            confirmButtonText: 'OK'
        });
        console.error('Error:', error);
    }
}
