import Vuex from "vuex";
import Vue from "vue";

import state from "./state";
import getters from "./getters";
import mutations from "./mutations";
import actions from "./actions";
Vue.use(Vuex);

import homeModule from './web/home.module';
import aboutModule from './web/about.module';
import authModule from './auth.module';
import accademicClass from './academic/class.module';
import accademicSession from './academic/session.module';




export default new Vuex.Store({
  getters,
  mutations,
  state,
  actions,
  modules: {
    home: homeModule,
    about:aboutModule,
    accademicClass:accademicClass,
    accademicSession:accademicSession,
    auth: authModule
  },

});
