const state = {
    aboutList: [],
    about: {}
};

const getters = {
    AppActiveUser(state, getters, rootState) {
        return rootState.AppActiveUser;
    },
    aboutList(state) {
        return state.aboutList;
    }
};

const mutations = {
    SET_ABOUT_DATA(state, data) {
        state.aboutList = data;
    }
};

const actions = {
    fetchAbout({ commit }, payload) {
       // console.log(payload);
        return new Promise((resolve, reject) => {
            axios
                .get("/api/web/get-latest-about-us", {
                    params: {
                        site_id: payload.site_id,
                        type: payload.type
                    }
                })
                .then(response => {
                   // console.log(response);
                    commit("SET_ABOUT_DATA", response.data);

                    resolve(response);
                })
                .catch(error => {
                  /*   payload.notify({
                        text: error.response.data.message,
                        time: 5000,
                        position: "top-right",
                        color: "warning"
                    }); */
                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });
                    reject(error);
                });
        });
    }
};

export default {
    namespaced: true,
    state,
    getters,
    mutations,
    actions
};
