const state = {
    logoPath: "",
    latestNotice: [],
    latestNoticeForSitebar: [],
    managementMsg: [],
 //   commonData: {},
    slidesList: [],
    specialImage: [],
    modalscreen: {},
    //sitesettings: {},

    eventList: [],
    theEvent: {},
    videoList: [],
    about_as: {},
    job_circular: {},
};

const getters = {

    logoPath(state) {
        return state.logoPath;
    },
    AppActiveUser(state, getters, rootState) {
        return rootState.AppActiveUser;
    },
    latestNotice(state) {
        return state.latestNotice;
    },
    latestNoticeForSitebar(state) {
        return state.latestNoticeForSitebar;
    },
    webEvents(state) {
        return state.eventList;
    },
    getEvent: state => _eventId => {
        return state.eventList.find(event => event.id === _eventId);
    },
    getByLessonId: state => _lessonId => {
        return state.eventList.filter(e => e.event.id === _lessonId);
    },
    webSlides(state) {
        return state.slidesList;
    },
    // webspecialImage(state) {
    //     return state.specialImage;
    // },
    // webmodalscreen(state) {
    //     return state.modalscreen;
    // },
    // websitesettings(state) {
    //     return state.sitesettings;
    // },
    managementMsg(state) {
        return state.managementMsg;
    },
    videoList(state) {
        return state.videoList;
    },
    aboutUs(state) {
        return state.about_as;
    },
    JobCircular(state) {
        return state.job_circular;
    },
    // commonData(state) {
    //     return state.commonData;
    // },

};

const mutations = {
    // SET_COMMON_DATA(state, data) {
    //     state.commonData = data;
    // },
    SET_LASTEST_NOTICE(state, data) {
        state.latestNotice = data;
    },
    SET_LASTEST_NOTICE_FOR_SITEBAR(state, data) {
        state.latestNoticeForSitebar = data;
    },
    SET_SLIDES_DATA(state, data) {
        state.slidesList = data;
    },
    // SET_SPECIAL_IMAGE_DATA(state, data) {
    //     state.specialImage = data;
    // },
    // SET_MODAL_IMAGE_DATA(state, data) {
    //     state.modalscreen = data;
    // },
    // SET_SITE_SETTINGS(state, data) {
    //     state.sitesettings = data;
    // },

    SET_EVENTS_DATA(state, data) {
        state.eventList = data;
    },
    SET_VIDEO_LIST(state, data) {
        state.videoList = data;
    },
    SET_MESSAGE_DATA(state, data) {
        state.managementMsg = data;
    },
    ABOUT_US(state, data) {
        state.about_as = data;
    },
    JOB_CIRCULAR(state, data) {
        state.job_circular = data;
    },


};

const actions = {
    fetchCommonData({ commit }, payload) {

        return new Promise((resolve, reject) => {
            axios.get("/api/web/get-common-data")
                .then(response => {

                    console.log(payload);
                   //   commit('SET_COMMON_DATA', response.data)

                    //  commit('SET_ALIAS', response.data.alias, { root: true })
                    commit("UPDATE_USER_INFO", response.data, { root: true });
                    resolve(response);


                })
                .catch(error => {
                   /*  payload.notify({
                        text: error.response.data.message,
                        time: 5000,
                        position: "top-right",
                        color: "warning"
                    }); */
                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });
                    reject(error);
                });
        });
    },
    fetchLatestNotice({ commit, rootState }) {
          console.log('rootState');
                    console.log(rootState);
        return new Promise((resolve, reject) => {
            axios
                .get("/api/web/get-latest-notice", {

                    params: {
                        site_id: rootState.AppActiveUser["SITE_ID"]
                    }
                })
                .then(response => {

                   //  console.log(response);
                    commit("SET_LASTEST_NOTICE", response.data);
                    resolve(response);
                })
                .catch(error => {
                  /*   payload.notify({
                        text: error.response.data.message,
                        time: 5000,
                        position: "top-right",
                        color: "warning"
                    }); */
                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });
                    reject(error);
                });
        });
    },
    fetchlatestNoticeForSitebar({ commit, rootState }) {
        // console.log('fetchcommondata');
        return new Promise((resolve, reject) => {
            axios
                .get("/api/web/get-latest-notice-for-sitebar", {
                    params: {
                        site_id: rootState.AppActiveUser["SITE_ID"]
                    }
                })
                .then(response => {
                   //  console.log(response);
                    commit("SET_LASTEST_NOTICE_FOR_SITEBAR", response.data);
                    resolve(response);
                })
                .catch(error => {
                  /*   payload.notify({
                        text: error.response.data.message,
                        time: 5000,
                        position: "top-right",
                        color: "warning"
                    }); */
                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });
                    reject(error);
                });
        });
    },
    fetchSlide({ commit }, payload) {
        // console.log('fetchcommondata');
        return new Promise((resolve, reject) => {
            axios
                .get("/api/web/get-slide-item",  {
                    params: {
                        site_id: payload.site_id
                      // site_id: rootState.AppActiveUser["SITE_ID"]
                    }
                })
                .then(response => {
                    commit("SET_SLIDES_DATA", response.data);
                    resolve(response);
                })
                .catch(error => {
                  /*   payload.notify({
                        text: error.response.data.message,
                        time: 5000,
                        position: "top-right",
                        color: "warning"
                    }); */
                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });

                    reject(error);
                });
        });
    },

    fetchEvent({ commit }, payload) {
        // console.log('fetchcommondata');
        return new Promise((resolve, reject) => {
            axios
                .get("/api/web/get-event-item",  {
                    params: {
                        site_id: payload.site_id
                    //   site_id: rootState.AppActiveUser["SITE_ID"]
                    }
                })
                .then(response => {
                  //    console.log(response.data);
                    commit("SET_EVENTS_DATA", response.data);
                   // commit("SET_SPECIAL_IMAGE_DATA", response.data[2]);
                   // commit("SET_MODAL_IMAGE_DATA", response.data[3]);
                  //  commit("SET_SITE_SETTINGS", response.data[4]);
                    resolve(response);
                })
                .catch(error => {
                  /*   payload.notify({
                        text: error.response.data.message,
                        time: 5000,
                        position: "top-right",
                        color: "warning"
                    }); */
                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });

                    reject(error);
                });
        });
    },

    getVideoList({ commit }, payload) {
        // console.log('fetchcommondata');
        return new Promise((resolve, reject) => {
            axios
            .get("/api/web/get-video-list-for-home", {
                params: {
                    site_id: payload.site_id
                }
            }).then(response => {
                commit("SET_VIDEO_LIST", response.data);
                resolve(response);
            })

        });
    },

    fetchMessage({ commit }, payload) {
        // console.log('fetchcommondata');
        return new Promise((resolve, reject) => {
            axios
                .get("/api/web/get-head-of-authority-message", {
                    params: {
                        site_id: payload.site_id
                    }
                })
                .then(response => {
                    commit("SET_MESSAGE_DATA", response.data);
                    resolve(response);
                })
                .catch(error => {
                 /*    payload.notify({
                        text: error.response.data.message,
                        time: 5000,
                        position: "top-right",
                        color: "warning"
                    }); */
                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });
                    reject(error);
                });
        });
    },

    aboutUs({ commit }, payload) {
        // console.log('fetchcommondata');
        return new Promise((resolve, reject) => {
            axios
                .get("/api/web/get-about-us", {
                    params: {
                        site_id: payload.site_id
                    }
                })
                .then(response => {
                    commit("ABOUT_US", response.data);
                    resolve(response);
                })
                .catch(error => {
                 /*    payload.notify({
                        text: error.response.data.message,
                        time: 5000,
                        position: "top-right",
                        color: "warning"
                    }); */
                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });
                    reject(error);
                });
        });
    },
    JobCircular({ commit }, payload) {
        // console.log('fetchcommondata');
        return new Promise((resolve, reject) => {
            axios
                .get("/api/web/get-job-circular", {
                    params: {
                        site_id: payload.site_id
                    }
                })
                .then(response => {
                    commit("JOB_CIRCULAR", response.data);
                    resolve(response);
                })
                .catch(error => {

                    toast({
                        type: "warning",
                        title: error.response.data.message
                      });
                    reject(error);
                });
        });
    },


};


export default {
    namespaced: true,
    state,
    getters,
    mutations,
    actions
};
