<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'The :attribute must be accepted.',
    'active_url' => 'The :attribute is not a valid URL.',
    'after' => 'The :attribute must be a date after :date.',
    'alpha' => 'The :attribute may only contain letters.',
    'alpha_dash' => 'The :attribute may only contain letters, numbers, and dashes.',
    'alpha_num' => 'The :attribute may only contain letters and numbers.',
    'array' => 'The :attribute must be an array.',
    'before' => 'The :attribute must be a date before :date.',
    'between' => [
        'numeric' => 'The :attribute must be between :min and :max.',
        'file' => 'The :attribute must be between :min and :max kilobytes.',
        'string' => 'The :attribute must be between :min and :max characters.',
        'array' => 'The :attribute must have between :min and :max items.',
    ],
    'boolean' => 'The :attribute field must be true or false.',
    'confirmed' => 'The :attribute confirmation does not match.',
    'date' => 'The :attribute is not a valid date.',
    'date_format' => 'The :attribute does not match the format :format.',
    'different' => 'The :attribute and :other must be different.',
    'digits' => 'The :attribute must be :digits digits.',
    'digits_between' => 'The :attribute must be between :min and :max digits.',
    'email' => 'The :attribute must be a valid email address.',
    'exists' => 'The selected :attribute is invalid.',
    'filled' => 'The :attribute field is required.',
    'image' => 'The :attribute must be an image.',
    'in' => 'The selected :attribute is invalid.',
    'integer' => 'The :attribute must be an integer.',
    'ip' => 'The :attribute must be a valid IP address.',
    'json' => 'The :attribute must be a valid JSON string.',
    'max' => [
        'numeric' => 'The :attribute may not be greater than :max.',
        'file' => 'The :attribute may not be greater than :max kilobytes.',
        'string' => 'The :attribute may not be greater than :max characters.',
        'array' => 'The :attribute may not have more than :max items.',
    ],
    'mimes' => 'The :attribute must be a file of type: :values.',
    'min' => [
        'numeric' => 'The :attribute must be at least :min.',
        'file' => 'The :attribute must be at least :min kilobytes.',
        'string' => 'The :attribute must be at least :min characters.',
        'array' => 'The :attribute must have at least :min items.',
    ],
    'not_in' => 'The selected :attribute is invalid.',
    'numeric' => 'The :attribute must be a number.',
    'regex' => 'The :attribute format is invalid.',
    'required' => 'The :attribute field is required.',
    'required_if' => 'The :attribute field is required when :other is :value.',
    'required_with' => 'The :attribute field is required when :values is present.',
    'required_with_all' => 'The :attribute field is required when :values is present.',
    'required_without' => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'same' => 'The :attribute and :other must match.',
    'size' => [
        'numeric' => 'The :attribute must be :size.',
        'file' => 'The :attribute must be :size kilobytes.',
        'string' => 'The :attribute must be :size characters.',
        'array' => 'The :attribute must contain :size items.',
    ],
    'string' => 'The :attribute must be a string.',
    'timezone' => 'The :attribute must be a valid zone.',
    'unique' => 'The :attribute has already been taken.',
    'url' => 'The :attribute format is invalid.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
        'site_name' => [
            'required' => 'Institute Name is required',
        ],
        'site_email' => [
            'required' => 'Email  is required',
            'unique' => 'The Email has already been taken',
        ],
        'address' => [
            'required' => 'Address is required',
        ],
        'academic_group_ids' => [
            'required' => 'Academic Group required',
        ],
        'board_id' => [
            'required' => 'Board is required',
        ],
        'start_date' => [
            'required' => 'Start Date is Required',
        ],
        'sub_module_ids' => [
            'required' => 'Select Al least One Submodules',
        ],
        'end_date' => [
            'required' => 'End Date is Required',
        ],

        'committee_name' => [
            'required' => 'Committee Name is Required',
        ],

        'shift_ids' => [
            'required' => 'Shift is Required',
        ],
        'academic_shift_ids' => [
            'required' => 'Shift is Required',
        ],
        'academic_version_ids' => [
            'required' => 'Version is Required',
        ],
        'academic_year_ids' => [
            'required' => 'Academic Year is Required',
        ],
        'academic_class_ids' => [
            'required' => 'Class is Required',
        ],


        'shift_id' => [
            'required' => 'Shift is Required',
        ],
        'academic_shift_id' => [
            'required' => 'Shift is Required',
        ],
        'academic_version_id' => [
            'required' => 'Version is Required',
        ],
        'academic_year_id' => [
            'required' => 'Academic Year is Required',
        ],
        'academic_class_id' => [
            'required' => 'Class is Required',
        ],
        'academic_section_id' => [
            'required' => 'Section is Required',
        ],
        'academic_class_group_id' => [
            'required' => 'Group is Required',
        ],

        'academic_session_id' => [
            'required' => 'Session is Required',
        ],


        'academic_board_id' => [
            'required' => 'Board is Required',
        ],
        'board_roll_number' => [
            'required' => 'Board Roll is Required',
        ],

        'transaction_number' => [
            'required' => 'Transaction ID is Required',
        ],

        'academic_payment_method_id' => [
            'required' => 'Payment Company is Required',
        ],

        'name_native_language' => [
            'required' => 'Name (Bangla) is Required',
        ],
        'father_name_native_language' => [
            'required' => 'Father Name (বাংলায়) is Required',
        ],
        'mother_name_native_language' => [
            'required' => 'Mother Name (বাংলায়) is Required',
        ],


        'swap_cancel_date' => [
            'required' => 'Please Select Date',
        ],
        'teacher_id' => [
            'not_in' => 'Please Select Teacher',
        ], 'subject_id' => [
            'not_in' => 'Please Select Subject',
        ],


        'academic_student_category_id' => [
            'required' => 'Student Category is Required',
        ],
        'first_name' => [
            'required' => 'First Name is Required',
        ],
        'father_name' => [
            'required' => 'Father Name is Required',
        ],
        'mother_name' => [
            'required' => 'Mother Name is Required',
        ],
        'student_contact_number' => [
            'required' => 'Contact Number is Required',
        ],
        'religion_id' => [
            'required' => 'Religion is Required',
        ],
        'gender_id' => [
            'required' => 'Gender is Required',
        ],
        'religion_subject_id' => [
            'required' => 'Religion Subject is Required',
        ],
        'date_of_birth' => [
            'required' => 'Date of Birth is Required',
        ],
        'student_roll_number' => [
            'required' => 'Roll Number is Required',
        ],
        'number_array' => [
            'required' => 'Select At Least one number',
        ],
        'country_id' => [
            'required' => 'Country Name is required.',
        ],
        'division_id' => [
            'required' => 'Division Name is required.',
        ],
        'district_id' => [
            'required' => 'District Name is required.',
        ],
        'thana_id' => [
            'required' => 'Thana Name is required.',
        ],


        'invoice_no' => [
            'required' => 'Invoice No is Required',
            'unique' => 'Invoice No has already been taken',
        ],


    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes' => [],

];
