<!DOCTYPE html>
<html>

<head>
    @php($site = getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <title>{{ $page_tittle }}</title>


</head>

<body>

    {{-- @include('default.site.layout.pdf-header') --}}


    @foreach ($card_data as $key => $value)
        <style>
            @font-face {
                font-family: 'Verdana';
                font-weight: 100;
                font-style: normal;
                font-variant: normal;
                src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
            }

            body {
                font-family: "Verdana", Arial, Helvetica, sans-serif;
                font-size: 12px;
            }


            .st-image {
                border-top-left-radius: 6px/51px;
                border-top-right-radius: 6px/51px;
                margin-top: 5px;
                border: 2px solid white !important;
                text-align: center;
                width: 72px;
                height: 77px;

            }

            .name {
                text-align: left;
                width: 20%;
                font-weight: bold;
                font-size: {{ $body_font_size }};
            }

            .value {
                width: 100%;
                text-transform: capitalize;
                font-weight: bold;
                font-size: {{ $body_font_size }};
            }

            .main-div {
                background-position: center;
                background-size: cover;
                background-repeat: no-repeat;
                border: .5px solid black;
                width: 205px;
                height: 326px;
                margin-bottom: 12.4111px;
                margin-left: 21px;
                float: left;
                overflow: hidden;
            }

            .site-logo {
                background: transparent;
                border-top-left-radius: 6px/51px;
                border-top-right-radius: 6px/51px;
                border-bottom-left-radius: 6px/51px;
                border-bottom-right-radius: 6px/51px;
                margin-top: 8px;
                height: 50px;
                width: 50px;
                margin-left: 10px
            }

            @page {
                size: 2330px 1730px;
                margin: 0;
                margin-bottom: 1px;
                /* Adjust to prevent extra blank pages */
            }
        </style>


        <div class="main-div" style="background-image: url({{ public_path($bg_path) }});">

            <table cellspacing="0" border="0" width="100%;">

                <tbody>

                    <tr style="">
                        <td style="width: 100%">
                            <div style="text-align:center">
                                <img class="site-logo" style="" src="{!! public_path($site_logo_path) !!}">
                                <p
                                    style="font-size:{{ $institute_name_font_size }}; text-transform:capitalize;font-weight: bold; margin:0px;padding:0px">
                                    {{ $site_name }}</p>
                            </div>

                        </td>
                    </tr>

                    <tr>
                        <td style=" width: 100%;text-align: center;padding: 2px">
                            <span
                                style="text-transform:uppercase;font-size: 15px; font-weight: bold; color: #ffffff"></span>

                        </td>
                    </tr>

                    <tr>
                        <td style="width: 50%; text-align: center;">
                            <img class="st-image"
                                src="{{ public_path('uploads/' . ($value['latest_photo'] ?? 'image-not.png')) }}">
                        </td>
                    </tr>

                    <tr>
                        <td style="width: 100%;text-align: center; padding: 2px">

                        </td>
                    </tr>
                    <tr style="width: 100%;text-align: center">
                        <td style="width: 100%;text-align: center">
                            <span
                                style="text-transform:uppercase;font-size: {{ $name_font_size }}; font-weight: bold; color: #21733A">
                                {{ $value['full_name'] ?? '--' }} </span>
                        </td>
                    </tr>
                    <tr style="width: 100%;font-weight: bold;font-size: 8px;text-align: center">

                        <td style="text-align: center;">
                            <b>Student ID No : {{ $value['username'] }}</b>
                        </td>
                    </tr>

                </tbody>

            </table>
            <div style="margin-left: 20px;margin-top: 2px">
                <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

                    <tbody style="margin-left: 100px">
                        <tr>
                            <th class="name">
                                <nobr>Father</nobr>
                            </th>
                            <td class="value">
                                : {{ $value['father_name'] ?? '--' }}
                            </td>
                        </tr>

                        <tr>
                            <th class="name">
                                <nobr>Mother</nobr>
                            </th>
                            <td class="value">
                                : {{ $value['mother_name'] ?? '--' }}
                            </td>
                        </tr>

                        <tr>
                            <th class="name">
                                <nobr>Class</nobr>
                            </th>
                            <td class="value">
                                @if ($value['class_name'] == 'XI')
                                    <nobr>: HSC</nobr>
                                @else
                                    <nobr>
                                        : {{ $value['class_name'] ?? '--' }}
                                        <!--({{ $value['shift_name'] ?? '_' }})-->
                                        <!--@if ($value['group_name'])-->
                                        <!--    <b>-->
                                        <!--        ({{ $value['group_name'] ?? '--' }})</b>-->
                                        <!--@endif-->
                                         @if ($value['student_roll_number'])
                                            ,
                                            Roll : {{ $value['student_roll_number'] ?? '--' }}
                                        @endif
                                    </nobr>
                                @endif
                            </td>
                        </tr>
                        @if ($value['class_name'] != 'Nine' && $value['class_name'] != 'Ten')
                            @if ($value['section_name'])
                                <tr>
                                    <th class="name">
                                        <nobr>Section</nobr>
                                    </th>
                                    <td class="value">
                                        : {{ $value['section_name'] ?? '--' }}
                                    </td>
                                </tr>
                            @endif
                         @endif


                        @if ($value['department_name'])
                            <tr class="name">
                                <th>
                                    Department
                                </th>
                                <td class="value">
                                    <nobr> : {{ $value['department_name'] ?? '--' }}</nobr>
                                </td>
                            </tr>
                        @endif
                        <!--@if ($value['class_name'] == 'Nine')-->
                        <!--    <tr>-->
                        <!--        <th class="name">-->
                        <!--            <nobr>Session</nobr>-->
                        <!--        </th>-->
                        <!--        <td class="value">-->
                        <!--            : {{ $value['session_name'] ?? '--' }}-->
                        <!--        </td>-->
                        <!--    </tr>-->
                        <!--@endif-->
                        <!--@if ($value['class_name'] == 'Nursery')
-->
                        <!--    <tr>-->
                        <!--        <th class="name">-->
                        <!--            <nobr>Section</nobr>-->
                        <!--        </th>-->
                        <!--        <td class="value">-->
                        <!--            : {{ $value['section_name'] ?? '--' }}-->
                        <!--        </td>-->
                        <!--    </tr>-->
                        <!--
@endif-->



                        <!--@if ($value['student_roll_number'])-->
                        <!--    <tr>-->
                        <!--        <th class="name">-->
                        <!--            <nobr>Roll</nobr>-->
                        <!--        </th>-->
                        <!--        <td class="value">-->
                        <!--            : {{ $value['student_roll_number'] ?? '--' }}-->
                        <!--        </td>-->
                        <!--    </tr>-->
                        <!--@endif-->
                        @if ($value['group_name'])
                            <tr>
                                <th class="name">
                                    <nobr>Group</nobr>
                                </th>
                                <td class="value">
                                    : {{ $value['group_name'] ?? '--' }}      @if ($value['section_name'])
                                            ,
                                            Section : {{ $value['section_name'] ?? '--' }}
                                        @endif
                                </td>
                            </tr>
                        @endif


                        @if ($value['blood_group'])
                            <tr>
                                <th class="name">
                                    <nobr>B. Group</nobr>
                                </th>
                                <td class="value">
                                    : {{ $value['blood_group'] ?? '--' }}
                                </td>
                            </tr>
                        @endif

                        @if ($value['contact_number'])
                            <tr>
                                <th class="name">
                                    <nobr>Mobile</nobr>
                                </th>
                                <td class="value">
                                    <nobr> : {{ $value['contact_number'] ?? '--' }}</nobr>
                                </td>
                            </tr>
                        @endif
                        <!--<tr>-->
                        <!--    <th class="name">-->
                        <!--        <nobr>Session</nobr>-->
                        <!--    </th>-->
                        <!--    <td class="value">-->
                        <!--        <nobr> : 2025</nobr>-->
                        <!--    </td>-->
                        <!--</tr>-->

                    </tbody>
                </table>
            </div>

            <table class="data-table" cellspacing="0" border="0" width="100%;" style="">
                <tr>
                    <th colspan="3"></th>
                </tr>

                <tr>

                    <td colspan="2" style="text-align:left; padding-right:15px;">

                        <div style="position: absolute;top:-8px;margin-left: 15px">
                            <img width="80" src="{{ public_path($signature) }}"
                                style="position: absolute;top:12px;left: -10px">
                            <br><br>
                            <span
                                style="border-top: 1px dotted black; font-weight:bold padding: 0 10px; font-size:8px">{{ $designation }}</span>
                        </div>
                    </td>

                    <td style="width: 100%; " style="">
                        @if ($showQRCode)
                        <img width="45" style="position: absolute;top:-10px;margin-left:20px"
                                src="data:image/png;base64, {!! base64_encode(
                                    QrCode::size(48)->generate(
                                        $domain . '/site-public/student-details/' . $value['username'] . '.' . $site_id . '.' . $value['history_id'],
                                    ),
                                ) !!}">

                        @endif

                    </td>
                </tr>

            </table>


        </div>
        @if (($key + 1) % 10 == 0)
            <div style="clear:both;"></div>
        @endif

        @if (($key + 1) % 50 == 0 && $key + 1 != count($card_data))
            <div class="page-break"></div>
        @endif
    @endforeach


</body>


<style>

</style>

</html>
