<!DOCTYPE html>
<html>

<head>
    @php($site = getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <title>{{ $page_tittle }}</title>

    <style>
        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .st-image {
            text-align: center;
            width: 70px;
            height: 80px;
            padding-top: 30px;
        }

        .data-table th {
            font-size: 9px;
            text-align: left;
            line-height: 100%;
        }

        .data-table td {
            font-size: 9px;
            text-align: left;
            line-height: 120%;
        }

        .page-break {
            page-break-after: always;
        }

        .main-div {
            background-position: center;
            background-size: cover;
            background-repeat: no-repeat;
            border: .5px solid black;
            width: 205px;
            height: 326px;
            margin-bottom: 12.4111px;
            margin-left: 21px;
            float: left;
            overflow: hidden;
        }

        .site-logo {
            background: transparent;
            height: 36px;
            width:38px;
            margin-top: 2px;
        }

        /* Prevent last page break */
        .page-break:last-child {
            display: none;
        }

        @page {
            size: 2330px 1730px ;
            margin: 0;
            margin-bottom: 1px; /* Adjust to prevent extra blank pages */
        }
    </style>
</head>

<body>

    @foreach ($card_data as $key => $value)
        <div class="main-div" style="background-image: url({{ public_path($bg_path) }});">

        </div>

        @if (($key + 1) % 10 == 0)
            <div style="clear:both;"></div>
        @endif

        @if (($key + 1) % 50 == 0 && ($key + 1) != count($card_data))
            <div class="page-break"></div>
        @endif
    @endforeach

</body>
</html>
