<!DOCTYPE html>
<html>
<head>
    @php($site = getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <title>{{ $page_tittle }}</title>
    <style>
        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana",Arial;
            font-size: 12px;
        }
        .st-image {
            border-top-left-radius: 5px/50px;
            border-top-right-radius: 5px/50px;
            margin-top: 8px;
            text-align: right;
            width: 86px;
            height: 94px;
            border: 2px solid white;

        }

        .data-table th {
            padding-left: 5px;
            font-size: 9px;
            text-align: left;
            line-height: 100%;
        }

        .data-table td {
            font-size: 9px;
            text-align: left;
            line-height: 100%;
        }

        .page-break {
            page-break-after: always;
        }

        .main-div {
            background-position: center;
            background-size: cover;
            background-repeat: no-repeat;
            border: 0px solid black;
            transform: rotate(90deg);
            width: 192px;
            padding: 2px 6px;
            height: 320px;
            margin: 0 0 0 0;
            margin-top: -34px;
            margin-left: 184px;
            border-radius: 5px;
            float: center;
            overflow: hidden;

        }

        .site-logo {
            background: transparent;
            height: 30px;
            padding-right: 5px;
        }
    </style>

</head>

<body>


    @foreach ($card_data as $key => $value)


        <div class="main-div" style="background-image: url({{ public_path($bg_path) }});">

            <table cellspacing="0" border="0" width="100%;">

                <tbody>
                    <tr>
                        <td style="width: 100%;text-align: center; padding: 3px">

                        </td>
                    </tr>
                    <tr style= "width:100%; font-size: 8px; text-transform:capitalize;font-weight: bold">

                        <th>
                            <img class="site-logo" style="text-align: left" src="{!! public_path($site_logo_path) !!}">

                        </th>
                        <th>
                            <span style="font-size: 12px;text-align: left; text-transform:capitalize;font-weight: bold">
                                <nobr>Darul Ulum Kamil Madrasah
                            </span></nobr>
                            </br>Chandanpura, Chawkbazar, Chattogram
                        </th>
                    </tr>
                </tbody>
            </table>
            <table cellspacing="0" border="0" width="100%;">
                <tbody>
                    <tr>
                        <td style="width: 100%;text-align: center">
                            @if (file_exists(public_path('uploads') . '/' . $value['latest_photo']))
                                <img class="st-image"
                                    src="{{ asset('uploads') . '/' . $value['latest_photo'] ?? 'image-not.png' }}">
                            @else
                                <img class="st-image" src="{{ asset('uploads') . '/image-not.png' }}">
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%;text-align: center; padding: 2px">

                        </td>
                    </tr>
                    <tr style="width: 100%;text-align: center">
                        <td style="width: 100%;text-align: center">
                            <span style="text-transform:uppercase;font-size: 11px; font-weight: bold; color: #21733A">
                                {{ $value['full_name'] ?? '--' }} </span>
                        </td>
                    </tr>
                    <tr style="width: 100%;font-size: 10px;text-align: center">

                        <td style="text-align: center">
                            <b>Student ID No. : {{ $value['username'] }}</b>
                        </td>
                    </tr>

                </tbody>

            </table>
            <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

                <tbody>
                    <tr>
                        <th style="width: 15%;">
                            <nobr> Father</nobr>
                        </th>
                        <td style="width: 100%;font-size: 9px">
                            : {{ $value['father_name'] ?? '--' }}
                        </td>
                    </tr>

                    <tr>
                        <th>
                            <nobr> Mother</nobr>
                        </th>
                        <td style="width: 100%;font-size: 9px">
                            <nobr> : {{ $value['mother_name'] ?? '--' }}</nobr>
                        </td>
                    </tr>


                    @if ($value['department_name'])
                        <tr>
                            <th>
                                Department
                            </th>
                            <td>
                                <nobr> : {{ $value['department_name'] ?? '--' }}</nobr>
                            </td>
                        </tr>
                    @endif
                    <tr>
                        <th>
                            Class
                        </th>
                        <td>

                            @if ($value['class_name'] == 'XI')
                                <nobr>: HSC</nobr>
                            @else
                                <nobr>
                                    : {{ $value['class_name'] ?? '--' }} @if ($value['group_name'])
                                        <b>
                                            ({{ $value['group_name'] ?? '--' }})</b>
                                    @endif
                                </nobr>
                            @endif

                        </td>

                    </tr>
                    @if ($value['session_name'])
                        <tr>
                            <th>
                                Session
                            </th>
                            <td>
                                <nobr> : {{ $value['session_name'] ?? '--' }}</nobr>
                            </td>
                        </tr>
                    @endif
                    @if ($value['student_roll_number'])
                        <tr>
                            <th>
                                Roll
                            </th>
                            <td>
                                <nobr> : {{ sprintf('%02d', $value['student_roll_number'] ?? '') }}</nobr>
                            </td>
                        </tr>
                    @endif
                    @if ($value['blood_group'])
                        <tr>
                            <th>
                                B. Group
                            </th>
                            <td>
                                <nobr> : {{ $value['blood_group'] ?? '--' }}</nobr>
                            </td>
                        </tr>
                    @endif
                    <tr>
                        <th>
                            Birth
                        </th>
                        <td>
                            <nobr>
                                : {{ date('d M Y', strtotime($value['date_of_birth'] ?? '1970-12-16')) }}</nobr>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            Mobile
                        </th>
                        <td>
                            <nobr> : {{ $value['contact_number'] ?? '--' }}</nobr>
                        </td>
                    </tr>
                </tbody>
            </table>

            <table class="data-table" cellspacing="0" border="0" width="100%;" style="">
                <tr>
                    <th colspan="3"></th>
                </tr>

                <tr>
                    <td colspan="2"
                        style="font-size: 8px; text-align:left;line-height: 50%; padding-left:10px;width: 100%;">
                        <br>
                        <br>
                        <img style="text-align: left; " width="70" src="{{ asset($signature) }}">
                        <br>
                        <br>
                        <span style="border-top: 1px dotted black;padding: 0 10px;">{{ $designation }}</span>

                    </td>

                    <td style="width: 100%;text-align: right; padding-right: 10px;padding-bottom:5px;">
                        @if ($showQRCode)
                            <img src="data:image/png;base64, {!! base64_encode(
                                QrCode::size(48)->generate(
                                    $domain . '/site-public/student-details/' . $value['username'] . '.' . $site_id . '.' . $value['history_id'],
                                ),
                            ) !!} ">
                        @endif

                    </td>
                </tr>

            </table>

        </div>


        @if (($key + 1) % 1 == 0)
            <div style="clear:both; height:-96px; margin-right: 0;"></div>
        @endif


        @if (($key + 1) % 2 == 0)
            <div class="page-break"></div>
        @endif
    @endforeach


</body>


<style>
    @page {
        size: a4;
        margin: 0;


    }

    body {
        margin: 10px 5px 3px;
        background-color: #ffffff;
    }
</style>

</html>
