@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('datepicker/css/datepicker.css') !!}
    {!! Html::style('datepicker/css/timepicker.css') !!}
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">

        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">
                    <div class="col-md-12" id="successMessage">
                        @if (count($errors) > 0)
                            <div class="alert alert-danger row">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        @if(session()->has('success'))
                            <div class="alert alert-success row">
                                <ul>
                                    <li>{{ session()->get('success') }}</li>
                                </ul>
                            </div>
                        @endif
                    </div>


                    <div class="custom_row">
                        <h2 class="form_title">
                            {{--                            {{ trans('sidebar.building_enrole_form') }}--}}
                            Class Group
                        </h2>
                    </div>


                    @if($mode)

                        {!! Form::open(array('route' => 'class-group-create')) !!}

                        <div class="row">
                            <div class="field_wrap col-sm-12">
                                {!! Form::label('group_name','Group Name:',['class'=>'col-sm-12']) !!}
                                {!! Form::text('group_name',null,['class'=>'form-control']) !!}
                            </div>
                        </div>


                        <div class="row">
                            <div class="submig_button">
                                <input class="sub btn btn-success" style="background-color:#0073b7" readonly="readonly"
                                       type="submit" value="Submit"></div>
                        </div>

                        {!!  Form::close()   !!}

                    @else

                        {!! Form::model($singleClassGroup, ['route' => ['class-group-edit', $singleClassGroup->id]]) !!}


                        <div class="row">
                            <div class="field_wrap col-sm-12">

                                {!! Form::label('group_name','Academic',['class'=>'col-sm-12']) !!}

                                {!! Form::text('group_name',null,['class'=>'form-control']) !!}

                            </div>
                        </div>


                        <div class="row">
                            <div class="submig_button">
                                <input class="sub btn btn-success" style="background-color:#0073b7"
                                       readonly="readonly" type="submit" value="Update"></div>
                        </div>

                        {!!  Form::close()   !!}

                    @endif

                </div>
            </div>


            <div class="row">
                <div class="col-md-12 table-responsive">
                    <table class="table table-responsive table-bordered">
                        <thead>

                        <tr>
                            <th>#</th>
                            <th>Group Name</th>
                            <th>Action</th>
                        </tr>

                        </thead>

                        <tbody>
                        @set('sl',1)
                        @if(!$classGroupList->isEmpty())
                            @foreach($classGroupList as $classgroup)
                                <tr>
                                    <td>{{$sl++}}</td>
                                    <td>{{$classgroup->group_name}}</td>


                                    <td>
                                        <a class="btn btn-success btn-xs mrg"
                                           data-original-title="Edit"
                                           data-toggle="tooltip"
                                           href="{{ route('class-group-edit',[$classgroup->id]) }}">
                                            <i class="fa fa-edit"></i>
                                        </a>

                                        <a class="btn btn-danger btn-xs mrg"
                                           onClick="return confirm('Are you confirm to delete this data!')"
                                           href="{{ route('class-group-delete',[$classgroup->id]) }}">
                                            <i class="fa fa-trash-o"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="4">
                                    <strong>No data found</strong>
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>

                </div>
            </div>


        </div>
    </div>



@endsection

@section('scripts')
    {!! Html::script('datepicker/js/bootstrap-datepicker.js') !!}
    @parent




@endsection

