@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <a href="{{route('district-list')}}">
                        <span class="glyphicon glyphicon-user "
                              aria-hidden="true"></span>{{ trans('sidebar.district_list') }}</a>
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <a href="{!! route('district-add-form') !!}"><i
                                            class="fa fa-plus"></i> {{ trans('sidebar.district-create') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-print"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}
                    </button>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12">
                            <div class="box">

                                <div class="box-body auto_scroll">
                                    @if (count($errors) > 0)
                                        <div class="alert alert-danger row">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                    @if(session()->has('success'))
                                        <div class="alert alert-success row">
                                            <ul>

                                                <li>{{ session()->get('success') }}</li>

                                            </ul>
                                        </div>
                                    @endif
                                    <table id="example1" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th class="th_width_100">{{ trans('translate.sl') }}</th>
                                            <th>{{ trans('sidebar.country_name') }}</th>
                                            <th>{{ trans('sidebar.division_name') }}</th>
                                            <th>{{ trans('sidebar.district_name') }}</th>
                                            <th>{{ trans('sidebar.govt_code') }}</th>
                                            <th>{{ trans('translate.status') }}</th>
                                            <th class="text-center th_width_80">{{ trans('translate.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        @set('sl',1)
                                        @foreach($districtList as $district)


                                            <tr>
                                                <td>{{$sl++}}</td>
                                                <td>
                                                    {{ $district->division->country->country_name ?? '' }}
                                                </td>
                                                <td>
                                                    {{ $district->division->division_name ?? ''}}
                                                </td>
                                                <td>
                                                    {{$district->district_name ?? ''}}
                                                </td>
                                                <td>
                                                    {{$district->govt_code ?? ''}}
                                                </td>
                                                <td>{{ getActiveInactive($district->status) }}</td>
                                                <td>

                                                    <nobr>
                                                        <a class="btn btn-success btn-xs"
                                                           data-original-title="District"
                                                           data-toggle="tooltip"
                                                           target="_blank"
                                                           href="{{ route('thana-add-form',[$district->id]) }}"> <i
                                                                    class="fa fa-creative-commons"></i> New Thana
                                                        </a>

                                                        <a class="btn btn-success btn-xs"
                                                           data-original-title="District"
                                                           target="_blank"
                                                           data-toggle="tooltip"
                                                           href="{{ route('thana-list',[$district->id]) }}">

                                                            <i class="fa fa-file"></i>   Thanas
                                                            ({{$district->thanas->count() ?? 'n|a'}})
                                                        </a>


                                                    <a class="btn btn-success btn-xs mrg"
                                                       data-original-title="{{ trans('translate.edit') }}"
                                                       data-toggle="tooltip"
                                                       href="{{ route('district-edit-form',[$district->id]) }}"><i
                                                                class="fa fa-edit"></i></a>

                                                    <a class="btn btn-danger btn-xs delete_btn mrg"
                                                       onclick="return confirm('Are you sure?')"
                                                       data-original-title="{{ trans('translate.delete') }}"
                                                       data-toggle="tooltip"
                                                       href="{{ route('district-delete',[$district->id]) }}"><i
                                                                class="fa fa-trash-o"></i></a>
                                                </td>

                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>
                                    <div class="pagination">{!!   str_replace('/?','?',$districtList->render() ) !!} </div>
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>



@endsection
@section('scripts')

    @parent
    <script src="{{ asset('theme_components/admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    {!! Html::script('theme_components/admin/plugins/datatables/dataTables.bootstrap.min.js') !!}

@endsection