<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$report_tittle}}</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }

        table {
            font-size: x-small;
        }

        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }

        .gray {
            background-color: lightgray
        }

        @page {
            size: 21cm 29.7cm;
            margin: 15px;

        }

        body {
            border: 1px dotted black;
            padding: 2px;
            border-radius: 5px;

        }
    </style>

</head>
<body>

<table width="100%">
    <tr>
        <td valign="top">
            {{--<img src="{{asset('images/meteor-logo.png')}}" alt="" width="150"/>--}}
            <img src="{{asset('image/named-logo.jpg')}}" width="120" height="20">

        </td>
        <td align="right">
            <address>
                <strong>Edu world</strong>
                <br/>info@eduworld.com.bd
                <br/>+88 01901-029440
            </address>

        </td>
    </tr>

</table>

<table width="100%">
    <tr>

        <td>

            Bill To
            <address>
                <strong>{{$the_invoice->siteInfo->site_name ?? 'N/A'}}</strong>
                <br/>
                <strong>{{$the_invoice->siteInfo->address ?? 'N/A'}}</strong>
                <br>
                {{$the_invoice->siteInfo->site_phone}}
            </address>
        </td>
        <td style=" font-size: 12px; text-align: right; vertical-align: bottom;">

            <strong>Invoice no.:</strong>{{$the_invoice->invoice_no}}
            <br>
            <strong>Invoice Date: </strong>{{date('d F Y',strtotime($the_invoice->invoice_date))}}
            <br>
            <strong>Due Date: </strong>{{date('d F Y',strtotime($the_invoice->due_date))}}
            <br>
            <strong>Payment Date: </strong>
            @if(count($the_invoice->payments))
                {{date('d F Y',strtotime($the_invoice->payments->last()->payment_date ??  ''))}}

            @else
                <span style="color:red;"> Due Invoice</span>
            @endif
        </td>
    </tr>


    <tr>
        <td></td>
        <td style=" font-size: 12px; text-align: right; vertical-align: bottom;">
            <b>Printed At:</b> {{date('d-m-Y h:i:s A',time())}}
        </td>
    </tr>

</table>

<br/>

<table width="100%">
    <thead style="background-color: lightgray;">
    <tr>
        <th>#</th>
        <th>Particulars</th>
        <th>Month For</th>
        <th align="right">Unit Price</th>
        <th align="right">Quantity</th>
        <th align="right"> Tax</th>
        <th align="right"> Price</th>
    </tr>
    </thead>
    <tbody>

    @if(count($the_invoice->details)>0)
        @php($total=0 )
        @php($paid_total=0 )

        @foreach($the_invoice->details as $k=>$value)
            <tr>
                <th scope="row">{{$k+1}}</th>
                <td>{{$value->item->item_name}}</td>
                <td>
                    @if($value->month)
                        {{$value->month->name ?? ''}}    {{date('Y',strtotime($the_invoice->invoice_date))}}
                    @endif
                </td>
                <td align="right">{{$value->item_price}}</td>
                <td align="right">{{$value->item_quantity}}</td>
                <td align="right">
                    @if($value->tax_percentage)
                        ( {{$value->tax_percentage}} %)
                    @endif

                    {{$value->total_tax}}
                </td>
                <td align="right">
                    {{$value->item_final_amount}}
                </td>
            </tr>
            {{$total =( $total + ($value->piece_price * $value->piece))}}
            {{$paid_total =( $paid_total + ($value->paid_amount))}}



        @endforeach
    @endif
    </tbody>

    <tfoot>
    <tr>
        <td colspan="5"></td>
        <td align="right">Subtotal</td>
        <td align="right"> {{number_format($the_invoice->sub_total,2)}}</td>
    </tr>

    <tr>
        <td colspan="5"></td>
        <td align="right">Tax
            @if($the_invoice->tax_percentage)
                ( {{$the_invoice->tax_percentage}} %)
            @endif
        </td>
        <td align="right">(+) {{number_format($the_invoice->total_tax,2)}}</td>
    </tr>

    <tr>
        <td colspan="5"></td>
        <td align="right">Previous Due</td>
        <td align="right">(+) {{number_format($the_invoice->previous_due,2)}}</td>
    </tr>

    <tr>
        <td colspan="5"><b>Note: </b><i>{{$the_invoice->note}}</i></td>
        <td align="right">Discount</td>
        <td align="right">(-) {{number_format($the_invoice->discount_amount,2)}}</td>
    </tr>


    <tr>
        <td colspan="5"></td>
        <td align="right">Total Paid</td>
        <td align="right">{{number_format(($the_invoice->amount_paid),2)}}</td>
    </tr>
    -
    <tr>
        <td colspan="5"></td>
        <td align="right">Due</td>
        <td align="right" class="gray">{{number_format($the_invoice->amount_due,2)}}</td>
    </tr>

    <tr>
        <td colspan="4">In word :

            @if($the_invoice->amount_due)
                {{ucwords( convertNumberToWord($the_invoice->amount_due))}}
            @else
                {{ucwords( convertNumberToWord($the_invoice->amount_paid))}}
            @endif
             Only
        </td>
        <td colspan="3"></td>
    </tr>

    <tr>
        <td style="color: #2d6987; font-size: 10px" colspan="3">N.B. computer generated document, no signature
            required
        </td>

        <td colspan="4" style="color: #0a0302; font-size: 10px" >

            Please Pay Through
            <br>
            ----------------------------   <br>
            Acc. Name: THE WORLD
            <br>
            A/C. 02 10209553 001
            <br>
            IFIC Bank, Khulshi Branch, Chattogram
        </td>
    </tr>
    </tfoot>
</table>

</body>
</html>
