@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')


    <div class="container-fluid min_height_area">

        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li class="active text-capitalize">
                                <a href="{{ route('menu-list') }}">{{ trans('breadcrumb.menu.list') }}</a>

                            </li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div> <!--row-->
        <div class="inner-box-1">
            <div class="row">


                <div class="col-sm-12 col-md-12 table-responsive">
                    @if(count($auditLogs))


                        <table class=" table table-bordered table-striped">
                            <thead class="th-bg">
                            <tr>
                                <th>
                                    ID
                                </th>
                                <th>
                                    Description
                                </th>
                                <th>
                                    Subject id
                                </th>
                                <th>
                                    Subject Type
                                </th>

                                <th>
                                    Properties
                                </th>
                                <th>
                                    User
                                </th>
                                <th>
                                    IP
                                </th>
                                <th>
                                    Created At
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($auditLogs as $key => $auditLog)
                                <tr>
                                    <td>
                                        {{ $auditLog->id ?? '' }}
                                    </td>
                                    <td>
                                        {{ $auditLog->description ?? '' }}
                                    </td>
                                    <td>
                                        {{ $auditLog->subject_id ?? '' }}
                                    </td>
                                    <td>
                                        {{ $auditLog->subject_type ?? '' }}
                                    </td>

                                    <td>
                                        {{ $auditLog->properties ?? '' }}
                                    </td>
                                    <td>
                                        {{ $auditLog->user->full_name ?? '' }}
                                    </td>
                                    <td>
                                        {{ $auditLog->host ?? '' }}
                                    </td>
                                    <td>
                                        {{date('d M Y h:i:s A', strtotime($auditLog->created_at) )}}
                                    </td>

                                    {{--<td>--}}
                                    {{--@can('audit_log_show')--}}
                                    {{--<a class="btn btn-xs btn-primary"--}}
                                    {{--href="{{ route('admin.audit-logs.show', $auditLog->id) }}">--}}
                                    {{--{{ trans('global.view') }}--}}
                                    {{--</a>--}}
                                    {{--@endcan--}}
                                    {{--@can('audit_log_edit')--}}
                                    {{--<a class="btn btn-xs btn-info"--}}
                                    {{--href="{{ route('admin.audit-logs.edit', $auditLog->id) }}">--}}
                                    {{--{{ trans('global.edit') }}--}}
                                    {{--</a>--}}
                                    {{--@endcan--}}
                                    {{--@can('audit_log_delete')--}}
                                    {{--<form action="{{ route('admin.audit-logs.destroy', $auditLog->id) }}"--}}
                                    {{--method="POST"--}}
                                    {{--onsubmit="return confirm('{{ trans('global.areYouSure') }}');"--}}
                                    {{--style="display: inline-block;">--}}
                                    {{--<input type="hidden" name="_method" value="DELETE">--}}
                                    {{--<input type="hidden" name="_token" value="{{ csrf_token() }}">--}}
                                    {{--<input type="submit" class="btn btn-xs btn-danger"--}}
                                    {{--value="{{ trans('global.delete') }}">--}}
                                    {{--</form>--}}
                                    {{--@endcan--}}
                                    {{--</td>--}}

                                </tr>
                            @endforeach
                            </tbody>


                            <tfoot>
                            <tr>
                                <td colspan="5">
                                    {!!   str_replace('/?','?',$auditLogs->render() ) !!}
                                </td>
                            </tr>
                            </tfoot>


                        </table>

                    @endif
                </div>
            </div>
        </div>
    </div>


@endsection
@section('scripts')


    {!! Html::script('select/js/select2.min.js') !!}
    <script type="text/javascript">
        $(document).ready(function () {
            $('select1').select2();

        });
    </script>

@endsection