@inject('genderList','App\Lists\GenderList')
@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid" style="min-height: 1215px;">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-6">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>{{ trans('sidebar.gender_list') }}
                    </div>
                    <div class="col-md-6 col-xs-6 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <a href="{!! route('gender-add-form') !!}"><i class="fa fa-plus"></i> {{ trans('sidebar.gender-create') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}</button>

                </div>
            </div>

            <div class="col-md-12">


                @if (count($errors) > 0)
                    <div class="alert alert-danger row">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @if(session()->has('success'))
                    <div class="alert alert-success row" >
                        <ul>
                            <li>{{ session()->get('success') }}</li>
                        </ul>
                    </div>
                @endif


            </div>


        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">

                        <div class="col-sm-12 col-xs-12">

                            <div class="box">
                                <div class="box-body auto_scroll">

                                    <table id="example1" class="table table-bordered table-striped table-responsive">
                                        <thead>
                                        <tr>
                                            <th class="th_width_100">{{ trans('translate.sl') }}</th>
                                            <th>{{ trans('translate.gender') }}</th>
                                            <th>{{ trans('translate.status') }}</th>
                                            <th class=" text-center th_width_100">{{ trans('translate.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @set('sl',1)
                                        @foreach($model as $gender)
                                            <tr>
                                                <td>{{ $sl++ }}</td>
                                                <td>{{ $gender->gender_name ?? 'Null' }}</td>
                                                <td>{{ $gender->status ?? 'Null' }}</td>
                                                <td class="text-center">
                                                    <a class="btn btn-info btn-xs mrg" data-original-title="{{ trans('translate.view') }}" data-toggle="tooltip" href="{{ route('gender-view',[$gender->id]) }}"><i class="fa fa-edit"></i></a>
                                                    <a class="btn btn-success btn-xs mrg" data-original-title="{{ trans('translate.edit') }}" data-toggle="tooltip" href="{{ route('gender-edit-form',[$gender->id]) }}"><i class="fa fa-edit"></i></a>
                                                    <a  class="btn btn-danger btn-xs delete_btn mrg"  onclick="return confirm('Are you sure?')" data-original-title="{{ trans('translate.delete') }}" data-toggle="tooltip" href="{{ route('gender-delete',[$gender->id]) }}"><i class="fa fa-trash-o"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>

                                    </table>

                                    <div class="pagination">{!!   str_replace('/?','?',$model->render() ) !!} </div>
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>



@endsection
