@inject('editMenu','App\Forms\MenuForm')
@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>
                        {{ trans('sidebar.edit_menu') }} /
                        {{-- {{ strtoupper($viewType) }} --}}
                        <span  aria-hidden="true">
                            <a href="{{ route('menu-list') }}"> {{ trans('sidebar.menu_list') }}</a>
                        </span>
                    </div>
                    <div class="col-md-6 snt">
                        <ul class="breadcrumb text-right">

                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('sidebar.dashboard') }}</a></li>
                            <li class="active">
                             {{ trans('sidebar.edit_menu') }}
                                {{-- {{ strtoupper($viewType) }} --}}
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-view">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">

                    @if (count($errors) > 0)
                        <div class="alert alert-danger row">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                        @if(session()->has('success'))
                            <div class="alert alert-success row">
                                <ul>

                                    <li>{{ session()->get('success') }}</li>

                                </ul>
                            </div>
                        @endif

                    <div class="custom_row">
                        {!! inputLangControl() !!}
                    </div>

                    <div class="custom_row">                      
                        <h2 class="form_title">
                            {{ trans('sidebar.edit_menu') }}
                        </h2>                                          
                    </div>

                    {!! Form::model(
                                $menuToEdit,
                                array(
                                'route' => ['menu-edit',$menuToEdit->id],
                                'files' => true,
                                'id'=>'create-form',
                                'class'=>'form-create',
                                'method'=>'PATCH'
                                ))
                    !!}

                        {!! formFields($editMenu,$mode='edit',$menuToEdit->id)  !!}

                    {!!  Form::close()   !!}

                </div>
            </div>
        </div>
    </div>



@endsection
@section('scripts')


    @parent
    {!! Html::script('select/js/select2.min.js') !!}
    {{-- <script src="{{ asset('jquery-validation/dist/jquery.validate.min.js') }}"></script>--}}

    <script type="text/javascript">
        $(document).ready(function(){
            $('#parent_id').select2();
            $(".translation_wrap").hide();
            $(".translation_wrap.trans_en"/*+lang_def*/).show();
            $(".control_lang").on("click",function(){
                var selected_lang = $(this).val();
                $(".translation_wrap").hide();
                $(".translation_wrap.trans_"+selected_lang).show();
                $(".control_lang").val(selected_lang);
            });

            getParentIds=function () {
                $('#position-div').html('<img src="/image/30.gif">');

                $.ajax({
                    url: "{{ route('get-position-list-for-parent-menu') }}",
                    type: "GET",
                    data: {
                        'parent_id': $("#parent_id").val()
                    },
                    success: function (data) {
                        console.log(data.length > 0)
                        if (data.length > 0) {
                            var htm = '';
                            data.forEach(function (item,k) {
                                if(k%50==0){
                                    htm += '</br>'
                                }
                                htm += '<span class="label label-info">' + item + '</span>'
                            });
                            $('#position-div').html(htm);
                        }else {
                            $('#position-div').html('No child menu Found!');

                        }

                    },
                    error: function (data) {
                        if (data.status = 401) {
                            $.growl.error({message: "Permission Denied!!!!"});
                        } else {
                            $.growl.error({message: "It has Some Error!"});
                        }
                    }, complete: function () {

                    }
                });
            }

            getParentIds();

            $("#parent_id").on("change", function () {
                getParentIds();
            });


        });
    </script>

@endsection