@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection



@section('content')
    <div class="container-fluid min_height_area" >
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li>
                                Communication
                            </li>
                            <li class="active text-capitalize"> Message View</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>

        <div class="inner-view">
            <div class="row">




                <div class="col-md-12">
                    <div class="panel panel-info">
                        <div class="panel-heading">

                            {{ $noticeData->translate($locale)? $noticeData->notice_name:$noticeData->translate($defaultLocale)->notice_name }}

                        </div>
                        <div class="panel-body">
                            <h6 style="text-align: right">{{ date('d-m-y h:m',strtotime($noticeData->notice_publish_date))}}</h6>
                            <div class="col-md-10 col-md-offset-1" style="text-align:justify">
                                {!! html_entity_decode($noticeData->translate($locale)? $noticeData->notice_description:$noticeData->translate($defaultLocale)->notice_description)!!}

                            </div>
                        </div>
                        <br>

                        <div class="panel-heading" >
                            @if($noticeData->notice_image != null)
                                <a href="#" data-toggle="modal" data-target="#myModal"><i class="fa fa-paperclip"></i>Attachment </a>
                            @endif
                        </div>




                    </div>
                </div>

                <!-- Modal -->
                <div id="myModal" class="modal fade" role="dialog">
                    <div class="modal-dialog">

                        <!-- Modal content-->
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h5 class="modal-title">{{ $noticeData->translate($locale)? $noticeData->notice_name:$noticeData->translate($defaultLocale)->notice_name }}</h5>
                            </div>
                            <div class="modal-body">
                                <p style="text-align: center">  {!!  Html::image('/img/site/messageImage/'.$noticeData->notice_image,'User Image', ['class'=>'img-responsive']) !!}</p>

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>

    </div>



@endsection


