@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')
    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>{{ trans('sidebar.section_list') }}
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <a href="{!! route('section_add_form') !!}"><i class="fa fa-plus"></i> {{ trans('sidebar.section-create') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}</button>
                    
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                @if(session()->has('success'))
                    <div class="alert alert-success">
                        <ul>

                            <li>{{ session()->get('success') }}</li>

                        </ul>
                    </div>
                @endif
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12">
                            <div class="box">
                                <div class="box-body auto_scroll">
                                    <table id="example1" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>{{ trans('translate.sl') }}</th>
                                            <th>{{ trans('translate.section_name') }}</th>
                                            {{--<th>{{ trans('translate.merit_level') }}</th>--}}
                                            {{--<th>{{ trans('translate.class_name') }}</th>--}}
                                            {{--<th>Teacher</th>--}}
                                            {{--<th>{{ trans('translate.total_result_system') }}</th>--}}
                                            <th>{{ trans('translate.status') }}</th>
                                            <th class="text-center th_width_80">{{ trans('translate.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @set('sl',1)

                                        @if(isset($sectionList) && !$sectionList->isEmpty())

                                            @foreach($sectionList as $section)
                                                <tr>
                                                    <td>{{ $sl++ }}</td>
                                                    <td>{{ $section->section_name ?? 'Not Available' }}</td>
                                                    {{--<td>{{ $section->merit_level ?? 'Not Available' }}</td>--}}
                                                    {{--<td>{{ $section->studentClass->class_name ?? 'Not Available' }}</td>--}}
                                                    {{--<td>{{ $section->classTeacher->first_name ?? 'Not Available'}} {{$section->classTeacher->last_name ?? 'Not Available' }}</td>--}}
                                                    {{--<td>{{ $section->totalResultSystem->name ?? 'Not Available' }}</td>--}}
                                                        <td>{{ getActiveInactive( $section->status) }}</td>
                                                        <td>
                                                            <a class="btn btn-success btn-xs mrg" data-original-title="{{ trans('translate.edit') }}" data-toggle="tooltip" href="{{ route('section-edit-form',[$section->id]) }}"><i class="fa fa-edit"></i></a>
                                                            <a  class="btn btn-danger btn-xs delete_btn mrg" data-original-title="{{ trans('translate.delete') }}" data-toggle="tooltip" href="{{ route('section-delete', [$section->id]) }}"><i class="fa fa-trash-o"></i></a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr>
                                                    <td colspan="12" class="text-center text-danger">
                                                        Sorry !!! No Section Found........
                                                    </td>
                                                </tr>


                                            @endif
                                            </tbody>
                                        </table>
                                        <div class="pagination">{!!   str_replace('/?','?',$sectionList->render() ) !!} </div>
                                    </div> <!-- box-body -->
                                </div> <!-- box -->
                            </div>
                        </div> <!-- row last -->
                    </div>
                </div>
            </div>
        </div>
    @endsection
    @section('scripts')

        @parent
        <script src="{{ asset('theme_components/admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
        {!! Html::script('theme_components/admin/plugins/datatables/dataTables.bootstrap.min.js') !!}

    @endsection
