<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>{{ $view_title }}</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }

        table {
            font-size: x-small;
            border-collapse: collapse;
            /* Ensures borders are not doubled */
            width: 100%;
        }

        .main-wrapper table th,
        td {
            border: 1px solid #000;
            padding: 5px;

        }

        .amount-right {
            text-align: right;
        }

        .gray {
            background-color: lightgray;
        }
    </style>

</head>

<body>

    <div class="main-wrapper" style="padding: 15px">
        @php($site = getSiteInfoForPdf())

        <div style="margin-bottom: 10px" class="header">
            <table width="100%;" border="0" >
                <tr style="">
                    <td style="width: 25%;" style="border: 0">
                        <span>
                            <img style="float: left" src="{{ public_path($site->site_logo) }}" width="60" height="55">
                        </span>
                    </td>
                    <td style="width: 52%; text-align: center; /*border: 1px solid green*/" style="border: 0">

                        <div style="width: 100%; text-align: center">
                            <span class="sitename" style="font-size: 14px; font-weight:bold ">{!! $site->site_name !!}</span>
                            <br>
                            <span style="font-size: 11px;">{!! $site->address !!}</span><br>
                            <span style="font-weight: bold">{!! $report_tittle !!} </span>
                        </div>
                    </td>
                    <td style="width: 23%;font-size: 10px;text-align: right;vertical-align: top;" style="border: 0">
                        <b>Printed :</b> {{ date('d M Y h:i:s ', time()) }}
                    </td>
                </tr>
            </table>

            @if ($report_tittle2)
                <table width="100%;" border="0">
                    <tr>
                        <td style="width: 50%; font-size: 10px;">
                            <span class="tittle">{!! $report_tittle2 !!}</span>

                        </td>

                        <td style="width: 30%; font-size: 10px; text-align: right; vertical-align: bottom; margin-top:50px">
                            {{-- <b>Printed :</b> {{date('d M Y h:i:s A',time())}} --}}
                        </td>
                    </tr>
                </table>
            @endif
        </div>
        <table width="100%">
            <thead style="background-color: #e2e6e9;">
                <tr>
                    <th align="left"><b>Particular</b></th>
                    <th align="right"><b>Amount</b></th>
                    <th align="right"><b>Total Amount</b></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td colspan="3" class="no-padding" style="text-align:left; padding:3px !important;">
                        <b>Income</b>
                    </td>
                </tr>
                @foreach ($final_income_data as $key => $value)
                    <tr>
                        <td class="no-padding" style="text-align:left; padding:3px !important;">
                            {{ $value['data']['name'] }}
                        </td>
                        <td class="no-padding" style="text-align:right; padding:3px !important;">
                            @if ($value['total_amount'] < 0)
                                <span>
                                    {{ number_format($value['total_amount'] * -1) }}
                                </span>
                            @endif
                            @if ($value['total_amount'] >= 0)
                                <span>
                                    {{ number_format($value['total_amount']) }}
                                </span>
                            @endif
                        </td>
                        <td></td>
                    </tr>
                @endforeach
                <tr>
                    <td class="no-padding" style="text-align:right; padding:3px !important;">
                        <span><b>Total Income</b></span>
                    </td>
                    <td></td>
                    <td class="no-padding" style="text-align:right; padding:3px !important;">
                        <span><b>{{ number_format($total_income) }}</b></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="3" class="no-padding" style="text-align:left; padding:3px !important;">
                        <b>Expense</b>
                    </td>
                </tr>
                @foreach ($final_expense_data as $k => $v)
                    <tr>
                        <td class="no-padding" style="text-align:left; padding:3px !important;">
                            <span>{{ $v['data']['name'] }}</span>
                        </td>
                        <td class="no-padding" style="text-align:right; padding:3px !important;">
                            @if ($v['total_amount'] < 0)
                                <span>
                                    {{ number_format($v['total_amount'] * -1) }}
                                </span>
                            @endif
                            @if ($v['total_amount'] >= 0)
                                <span>
                                    {{ number_format($v['total_amount']) }}
                                </span>
                            @endif
                        </td>
                        <td></td>
                    </tr>
                @endforeach
                <tr>
                    <td class="no-padding" style="text-align:right; padding:3px !important;">
                        <b>Total Expense</b>
                    </td>
                    <td></td>
                    <td class="no-padding" style="text-align:right; padding:3px !important;">
                        <b>{{ number_format($total_expense) }}</b>
                    </td>
                </tr>
                <tr>
                    <td class="no-padding" style="text-align:right; background-color:whitesmoke;">
                        <b>Total Profit and Loss</b>
                    </td>
                    <td></td>
                    <td class="no-padding" style="text-align:right; background-color:whitesmoke;">
                        @if ($total_profit_loss < 0)
                            <span style="color: red">
                                <b>TK {{ number_format($total_profit_loss * -1) }}</b>
                            </span>
                        @endif
                        @if ($total_profit_loss >= 0)
                            <span>
                                <b>TK {{ number_format($total_profit_loss) }}</b>
                            </span>
                        @endif
                    </td>
                </tr>
            </tbody>
        </table>
        <table width="100%">
            <!-- Uncomment and use if needed -->
            <!-- <span>Print Date: {{ $print_date }}</span> -->
        </table>
    </div>
</body>

<style>
    @page {
        size: a4;
        margin: 1px 0;
    }

    body {
        padding: 1px 6px 1px 6px;
    }
</style>

</html>
