<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }


        body{
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }


        .tittle {
            background-color: #dcdcdc;
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
            font-weight: bold;
        }

        .data-table td {
            border: 1px solid #999999;
            text-align: center;
        }




    </style>

</head>
<body>


<table width="100%;" border="0">
    <tr>
        <td style="width: 25%">
            <img src="{{public_path($site->site_logo)}}" width="55" height="55">
        </td>
        <td style="width: 50%; text-align: center">
            <span style="font-size: 15px;">{{$site->site_name}}</span> <br>
            <span style="font-size: 11px;">{{$site->address}}</span> <br>
             <br>

            <span class="tittle">{{$employee_full_name ?? ''}}'s Report From {{ date('d M Y',strtotime($start_date))  .' To '.date('d M Y',strtotime($end_date))}}</span>

            <span>
                {{$data[0]['data']->shiftDetail->shift->shift_name ?? ''}}
            </span>

        </td>
        <td style="width: 25%; font-size: 10px; text-align: right; vertical-align: bottom;">
            <b>Printed :</b> {{date('d-m-Y h:i:s A',time())}}
        </td>

    </tr>
</table>

<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <td style="width: 1px">S/L</td>
            <td>Date</td>
            <td>In</td>
            <td>Out</td>
            <td>Late Status</td>

        </tr>
        </thead>


        <tbody>
        @foreach($data as $key => $value)

            @if($value['data'])

            <tr>
                <td>{{$key +1}}</td>

                <td>




                  {{$value['data']->present_date ? date('d M Y',strtotime($value['data']->present_date)) : 'n/a'}}
                </td>
                {{--<td>{{$value['data']->shiftDetail->shift->shift_name ?? 'n/a'}}</td>--}}
                <td>
                  {{$value['data']->in_time ? date('h:i:s A',strtotime($value['data']->in_time)) : 'n/a'}}
                </td>
                <td>
                    {{$value['data']->out_time ? date('h:i:s A',strtotime($value['data']->out_time)) : 'n/a'}}
                </td>

                <td>
                    {{getLateIntime( $value['data']->late_status)}}
                </td>

            </tr>


            @else
            <tr>
                <td>{{$key +1}}</td>

                <td>
                    {{date('d M Y',strtotime($value['date']))}}
                </td>

                <td colspan="3">
                    {{$value['type']}}
                </td>

            </tr>



            @endif


        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












