<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employees Payroll PDF</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        .bg-info {
            background-color: #5bc0de;
            color: #fff;
        }

        .error {
            text-align: center;
            color: red;
        }

        .total-row {
            color: red;
            font-weight: bold;
        }

        .badge-success {
            color: #468847;
        }

        .badge-danger {
            color: #f11c00;
        }
    </style>
</head>

<body>
    <div>



        <div class="headerco" style="width: 100%; ">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 10%; text-align: left; border: none;">
                        <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                            src="{!! public_path(Session::get('LOGO_PATH')) !!}">
                    </td>
                    <td style="width: 100%; text-align:center;  padding-right:100px;  border: none;">
                        <span style="font-size:20px">{{ $site_info->site_name }}</span> <br>
                        {{ $site_info->address }}
                    </td>
                </tr>
            </table>
        </div>
        <div class="header-right" style="text-align: center">
            <strong>Payroll Report</strong>
        </div>


        <div class="new" style="text-align: right">
            @if ($startDate && $endDate)
                <span
                    style="color: red">{{ \Carbon\Carbon::parse($startDate)->format('d M Y') . ' - ' . \Carbon\Carbon::parse($endDate)->format('d M Y') }}</span>
            @endif
        </div>

        <table>
            <thead>
                <tr style="background-color: 	#c4c4c3">
                    <th>#</th>
                    <th>Name</th>
                    <th>User ID</th>
                    <th>Base salary</th>
                    <th>Bonus</th>
                    <th>Total pres.</th>
                    <th>Total abs.</th>
                    <th>Allowan.</th>
                    <th>Gross pay</th>
                    <th>Deduct.</th>

                    <th>Late Day </th>
                    <th>Late status</th>
                    <th>Late deductions</th>
                    <th>Unpaid leave deductions</th>
                    <th>Abs. status</th>
                    <th>Abs. deductions</th>

                    <th>Net pay</th>
                    <th>Pay date</th>
                </tr>
            </thead>

            <tbody>
                @if ($employees->isEmpty())
                    <tr>
                        <td colspan="12" class="text-center error">
                            No data!
                        </td>
                    </tr>
                @else
                    @foreach ($employees as $index => $employe)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $employe['full_name'] }}</td>
                            <td>{{ $employe['username'] }}</td>
                            <td>{{ number_format($employe['base_salary']) }}</td>
                            <td>{{ number_format($employe['bonus']) }}</td>
                            <td>{{ $employe['total_present'] }}</td>
                            <td>{{ $employe['total_absent'] }}</td>
                            <td>{{ number_format($employe['allowances']) }}</td>
                            <td>{{ number_format($employe['gross_pay']) }}</td>
                            <td>{{ number_format($employe['deductions']) }}</td>

                            <td>{{ $employe['totalCountableLateness'] }}</td>
                            <td><span
                                    class="badge-{{ $employe['late_status'] == 1 ? 'danger' : 'success' }}">{{ $employe['late_status'] == 1 ? 'Active' : 'Inactive' }}</span>
                            </td>
                            <td>{{ $employe['late_deductions'] }}</td>
                            <td>{{ $employe['unpaid_leave_deduction'] }}</td>
                            <td><span
                                    class="badge-{{ $employe['absent_status'] == 1 ? 'danger' : 'success' }}">{{ $employe['absent_status'] == 1 ? 'Active' : 'Inactive' }}</span>
                            </td>
                            <td>{{ $employe['absent_deductions'] }}</td>


                            <td>{{ number_format($employe['net_pay']) }}</td>
                            <td>{{ $employe['pay_date'] }}</td>
                        </tr>
                    @endforeach

                    <tr>
                        <td colspan="3" style="color: red;"><b>Total</b></td>
                        <td><b>{{ $totalBase_salary }}</b></td>
                        <td><b>{{ $totalBonus }}</b></td>
                        <td><b>{{ $total_present }}</b></td>
                        <td><b>{{ $total_absent }}</b></td>
                        <td><b>{{ $totalAllowances }}</b></td>
                        <td><b>{{ $totalGross_pay }}</b></td>
                        <td><b>{{ $totalDeductions }}</b></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td><b>{{ $totalNetPay }}</b></td>
                        <td></td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>
</body>

</html>
