<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
        }

        .container {
            width: 100%;
            margin: 0 auto;
        }

        .header {
            display: flex;
            justify-content: space-between;
            border-bottom: 1px dotted #000;
            padding-bottom: 10px;
        }

        .header-date {
            text-align: right;
        }

        .header-left {
            text-align: left;
        }

        .header-right {
            text-align: center;
            font-size: 20px;
            margin: 0;
            /* Removes any margin */
            padding: 0;
        }

        .header-left img {
            display: block;
            padding-top: 0px;
            margin: 0;
        }


        thead tr {
            background: #C4C4C3;
            text-align: center;
        }

        thead tr th {

            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        table,
        th,
        td {
            border: 1px solid #000;
        }

        th,
        td {
            padding: 6px;
            text-align: left;
        }

        .no-border {
            border: none;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .footer {
            margin-top: 30px;
            border-top: 1px dotted #000;
            padding-top: 10px;
            font-size: 12px;
        }

        .footer-note {
            margin-top: 30px;
            font-size: 10px;
        }

        .dotted-underline {
            border-bottom: 2px dotted #000;
            margin-top: 10px;
            width: 100%;
            /* Adds a dotted line below the text */
        }

        .dotted-top {
            border-top: 2px dotted #000;

            /* Adds a dotted line below the text */
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>

<body>
    <div class="container">
        @php
            $originalDate = "$year-$month";
            $carbonDate = \Carbon\Carbon::parse($originalDate);
            $formattedDate = $carbonDate->format('M-Y');
        @endphp



        <div class="headerco" style="width: 100%; ">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 10%; text-align: left; border: none;">
                        <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                            src="{!! public_path(Session::get('LOGO_PATH')) !!}">
                    </td>
                    <td style="width: 100%; text-align:center;  padding-right:75px;  border: none;">
                        <span style="font-size:20px">{{ $site_info->site_name }}</span> <br>
                        {{ $site_info->address }}
                    </td>
                </tr>
            </table>
        </div>
        <div class="header-right">
            <strong>Payment Voucher</strong>
        </div>


        <div class="header-info">
            <table style="width: 100%; margin-top: 10px; border: none;">
                <tr>
                    <td style="text-align: left; width: 80%;">
                        Pay to: <span class="dotted-underline"
                            style="font-weight: initial;">{{ $data['full_name'] }}</span>
                    </td>
                    <td style="text-align: right; width: 20%;">
                        Date: {{ Carbon\Carbon::now()->format('d-M-Y') }}
                    </td>
                </tr>
            </table>
        </div>

        <table>

            <thead>
                <tr>
                    <th>#</th>
                    <th>Particulars</th>
                    <th>Month For</th>
                    <th>Base salary</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text-center">1</td>
                    <td>Employe salary</td>
                    <td>{{ $formattedDate }}</td>
                    <td class="text-right">{{ $data['base_salary'] }}</td>
                    <td class="text-right">{{ $data['base_salary'] }}</td>
                </tr>
            </tbody>
            <tfoot>

                <tr>
                    <td colspan="4" class="text-right">Bonus</td>
                    <td class="text-right">(+) {{ $data['bonus'] }}</td>
                </tr>
                <tr>
                    <td colspan="4" class="text-right">Allowance</td>
                    <td class="text-right">(+) {{ $data['allowances'] }}</td>
                </tr>
                <tr>
                    <td colspan="4" class="text-right"><strong>Absent Deduction </strong></td>
                    <td class="text-right">(-) {{ $data['absent_deductions'] }}</td>
                </tr>
                <tr>
                    <td colspan="4" class="text-right"><strong>Unpaid leave deduction </strong></td>
                    <td class="text-right">(-) {{ $data['unpaid_leave_deduction'] }}</td>
                </tr>
                <tr>
                    <td colspan="4" class="text-right"><strong>Half Day leave deductions </strong></td>
                    <td class="text-right">(-) {{ $data['half_day_leave_deduction'] }}</td>
                </tr>
                <tr>
                    <td colspan="4" class="text-right"><strong>Late deduction </strong></td>
                    <td class="text-right">(-) {{ $data['late_deductions'] }}</td>
                </tr>
                <tr>
                    <td colspan="4" class="text-right"><strong>Total</strong></td>
                    <td class="text-right"><strong>{{ $data['net_pay'] }}</strong></td>
                </tr>
            </tfoot>
        </table>

        <span><strong>In word:</strong> {{ ucwords(convertNumberToWord($data['net_pay'])) }} </span>

        <div class="signature" style="width: 100%; margin-top: 30px;">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 50%; text-align: left; border: none;"><span class="dotted-top">Receiver
                            signature</span></td>
                    <td style="width: 50%; text-align: right; border: none;"><span class="dotted-top">Accountant
                            signature</span> </td>
                </tr>
            </table>
        </div>

        <br>








    </div>
</body>

</html>
