<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Examination Routine</title>
    <style>
       body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .page {
            border: 2px solid #000; /* Page border */
            padding: 10px;
            margin: 10px;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
        }
        .header h1 {
            font-size: 24px;
            margin: 0;
        }
        .header p {
            font-size: 14px;
            margin: 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table th, table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: center;
            font-size: 12px;
        }
        table th {
            background-color: #f4f4f4;
        }
        .footer {
            margin-top: 20px;
            text-align: right;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="page">
     <table width="100%;" border="0">
        <tr>
            <td style="width: 20%; border:none">
                <img style="float: left" src="{{public_path($site->site_logo)}}" width="60" height="55">
            </td>
            <td style="width: 60%; border:none">
                <div class="header">
                    <h2>Examination Routine</h2>
                    <h3>{{$site->site_name}}</h3>
                    <h4>{{$class_name}}-{{$shift_name}}</h4>
                    <h4>{{$examination_name}}- {{$year_name}}
                    </h4>
                </div>
            <td style="width: 20%; text-align: right; font-size: 10px; border:none">
                <b>Printed :</b> {{date('d M Y h:i:s A',time())}}
            </td>
        </tr>
    </table>

    <table>
        <thead>
            <tr>
                <th style="width:10px">#</th>
                <th>Subject</th>
                <th>Exam Type</th>
                <th>Date</th>
                <th>Time</th>
                <th style="width:20px">Duration (min)</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($subject_array as $kesse=>$subject)
                @foreach ($subject['exam_type_array'] as $key1=>$exam_type)
                <tr>
                    @if ($key1==0)
                    <td rowspan="{{count($subject['exam_type_array'])}}">{{$kesse+1}}</td>
                    <td rowspan="{{count($subject['exam_type_array'])}}">{{$subject['subject_name']}}</td>
                    @endif
                    <td>{{$exam_type['exam_type_name']}}</td>
                    <td>{{$exam_type['exam_start_date']}}</td>
                    <td>{{$exam_type['exam_start_time']}} - {{$exam_type['exam_end_time']}}</td>
                    <td>{{$exam_type['exam_duration']}}</td>
                </tr>
                @endforeach
            @endforeach
           
        </tbody>
        <tfoot>
            {{-- <table class="signature"  width="100%" >
                <tr>
                    <td style="text-align:left">
                        Powered by <br>
                        <img src="{{public_path("image").'/'.'edu.png'}}" width="70" height="20"><br>
                        <span style="font-size:8px; padding-left:10px">theworld.com.bd<span>
                    </td>


                    <th style="text-align: right !important; padding-right:40px">
                        <span>..............................</span><br>
                        <span>Head of Institution</span>
                    </th>
                </tr>
            </table> --}}
        </tfoot>
    </table>
</div>

</body>
</html>
