<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Job Application - {{ $candidate_profile['position'] ?? 'Position' }}</title>
    <style>
        @page {
            margin: 20px;
            size: A4;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 100%;
            max-width: 750px;
            margin: 0 auto;
        }

        .header {
            background-color: #4a5568;
            color: white;
            padding: 20px;
            text-align: center;
            margin-bottom: 20px;
        }

        .header h1 {
            font-size: 24px;
            margin: 0 0 5px 0;
            font-weight: bold;
        }

        .header p {
            font-size: 14px;
            margin: 0;
        }

        .section {
            margin-bottom: 20px;
            border: 1px solid #e2e8f0;
            padding: 15px;
        }

        .section-title {
            font-size: 16px;
            font-weight: bold;
            color: #2d3748;
            margin: 0 0 15px 0;
            padding-bottom: 5px;
            border-bottom: 2px solid #4a5568;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        .info-table td {
            padding: 8px;
            border-bottom: 1px solid #e2e8f0;
            vertical-align: top;
        }

        .info-table td:first-child {
            font-weight: bold;
            width: 150px;
            background-color: #f7fafc;
            color: #4a5568;
        }

        .status-approved {
            background-color: #48bb78;
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .status-pending {
            background-color: #ed8936;
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .status-rejected {
            background-color: #e53e3e;
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .cover-letter-box {
            background-color: #f7fafc;
            padding: 15px;
            border-left: 4px solid #4a5568;
            margin-top: 10px;
            font-style: italic;
        }

        .photo-section {
            width: 100px;
            height: 120px;
            border: 2px dashed #cbd5e0;
            background-color: #f7fafc;
            text-align: center;
            padding: 10px;
            float: right;
            margin-left: 20px;
            margin-bottom: 20px;
        }

        .photo-text {

        }
        .photo-text img {
            width: 100px;
            height: 120px;
        }

        .application-meta {
            background-color: #edf2f7;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
        }

        .meta-table {
            width: 100%;
            border-collapse: collapse;
        }

        .meta-table td {
            padding: 5px 0;
            border-bottom: 1px solid #cbd5e0;
        }

        .meta-table td:first-child {
            font-weight: bold;
            width: 120px;
            color: #4a5568;
        }

        .footer {
            text-align: center;
            font-size: 10px;
            color: #718096;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e2e8f0;
        }

        .clearfix::after {
            content: "";
            display: table;
            clear: both;
        }

        .two-column {
            width: 100%;
            border-collapse: collapse;
        }

        .two-column td {
            width: 50%;
            padding-right: 10px;
            vertical-align: top;
        }

        .two-column td:last-child {
            padding-right: 0;
            padding-left: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>JOB APPLICATION</h1>
            <p>Professional Application Document</p>
        </div>

        <!-- Photo Section -->
        @if(isset($candidate_profile['latest_photo']) && $candidate_profile['latest_photo'])
        <div class="photo-section">
            <div class="photo-text">

                <img src="{{ public_path($candidate_profile['latest_photo']['path'] ?? 'No Photo') }}" alt="">
            </div>
        </div>
        @endif

        <!-- Personal Information Section -->
        <div class="section">
            <h2 class="section-title">PERSONAL INFORMATION</h2>

            <table class="info-table">
                <tr>
                    <td>Full Name</td>
                    <td>{{ $candidate_profile['fullName'] ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Applied Position</td>
                    <td><strong>{{ $candidate_profile['position'] ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td>Email Address</td>
                    <td>{{ $candidate_profile['email'] ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Phone Number</td>
                    <td>{{ $candidate_profile['phone'] ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Address</td>
                    <td>{{ $candidate_profile['address'] ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Application Status</td>
                    <td>
                        @php
                            $status = $candidate_profile['status'] ?? 'Pending';
                            $statusClass = 'status-pending';
                            if (strtolower($status) === 'Approved') {
                                $statusClass = 'status-approved';
                            } elseif (strtolower($status) === 'Rejected') {
                                $statusClass = 'status-rejected';
                            }
                        @endphp
                        <span class="{{ $statusClass }}">{{ $status }}</span>
                    </td>
                </tr>
            </table>
        </div>

        <div class="clearfix"></div>

        <!-- Professional Background Section -->
        <div class="section">
            <h2 class="section-title">PROFESSIONAL BACKGROUND</h2>

            <table class="two-column">
                <tr>
                    <td>
                        <table class="info-table">
                            <tr>
                                <td>Experience Level</td>
                                <td>{{ ucfirst($candidate_profile['experience'] ?? 'N/A') }}</td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="info-table">
                            <tr>
                                <td>Education</td>
                                <td>{{ $candidate_profile['education'] ?? 'N/A' }}</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Cover Letter Section -->
        @if(isset($candidate_profile['coverLetter']) && !empty($candidate_profile['coverLetter']))
        <div class="section">
            <h2 class="section-title">COVER LETTER</h2>
            <div class="cover-letter-box">
                {{ $candidate_profile['coverLetter'] }}
            </div>
        </div>
        @endif

        <!-- Resume Section -->
        @if(isset($candidate_profile['resumeFileName']) && !empty($candidate_profile['resumeFileName']))
        <div class="section">
            <h2 class="section-title">RESUME</h2>
            <table class="info-table">
                <tr>
                    <td>Resume File</td>
                    <td>{{ $candidate_profile['resumeFileName'] }}</td>
                </tr>
            </table>
        </div>
        @endif

        <!-- Application Details -->
        <div class="application-meta">
            <table class="meta-table">
                <tr>
                    <td>Application ID:</td>
                    <td>#{{ $candidate_profile['id'] ?? 'N/A' }}</td>
                </tr>

                <tr>
                    <td>Applied Date:</td>
                    <td>
                        @if(isset($candidate_profile['appliedDate']))
                            {{ \Carbon\Carbon::parse($candidate_profile['appliedDate'])->format('F j, Y \a\t g:i A') }}
                        @else
                            N/A
                        @endif
                    </td>
                </tr>
                <tr>
                    <td>Last Updated:</td>
                    <td>
                        @if(isset($candidate_profile['updated_at']))
                            {{ \Carbon\Carbon::parse($candidate_profile['updated_at'])->format('F j, Y \a\t g:i A') }}
                        @else
                            N/A
                        @endif
                    </td>
                </tr>
            </table>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>This is an official job application document generated on {{ date('F j, Y') }}</p>
            <p>Application processed through Global Job Application System</p>
        </div>
    </div>
</body>
</html>
