<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">

    <style>
        .newT table {
            border-collapse: collapse;
            width: 100%;
            font-size: 12px;
            font-family: Verdana, Geneva, Tahoma, sans-serif;
        }

        .newT th,
        .newT td {
            border: 1px solid black;
            padding: 5px;
            text-align: center;
        }

        newT .th {
            background-color: #f2f2f2;
            height: 30px;
        }

        .signature tr th {
            text-align: center;
            border: none !important;
        }

        .sitename {
            font-size: 15px !important;
        }

        body {
            margin: 10px;
        }
    </style>

</head>

<body>

    <div>
        @include('default.site.layout.pdf-header')

        <div style="margin-top:10px;" class="newT">
            @foreach ($failed_subject_list as $failed_item)
                <h3>{{ $failed_item['failed_subject_count'] }} Subject Failed :</h3>
                <table class="table table-striped text-center student_table table" border="1" cellspacing="0" cellpadding="5">
                    <thead class="bg-primary">
                        <tr>
                            <th>#</th>
                            <th>User Name</th>
                            <th>Full Name</th>
                            <th>Roll</th>
                            <th>Failed Subject(s)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($failed_item['student_history_list'] as $index => $student)
                            <tr>
                                <td style="width: 10px;">{{ $index + 1 }}</td>
                                <td style="width: 30px;">{{ $student['username'] ?? '-' }}</td>
                                <td style="width: 170px;">{{ $student['full_name'] ?? '-' }}</td>
                                <td style="width: 10px;">{{ $student['student_roll_number'] ?? '-' }}</td>
                                <td>
                                    @foreach ($student['subject_list'] as $s_index => $subject)
                                        {{ $subject['subject_name'] ?? '-' }}
                                        @if ($s_index < count($student['subject_list']) - 1)
                                            ,
                                        @endif
                                    @endforeach
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endforeach
        </div>

        <div>
            <table style="margin-top:70px;" class="signature" width="100%">
                <tr>
                    <th style="float: left;">
                        <span>..............................</span><br>
                        <span>Convenor</span>
                    </th>

                    <th width='40%'></th>

                    <th style="float: right;">
                        <br>
                        <span>..............................</span><br>
                        <span>{{ $get_institute_head_designation ?? '' }}</span>
                    </th>
                </tr>
            </table>
        </div>

    </div>

</body>

<style>
    @page {
        size: A4 portrait;
        margin: 20px;
    }
</style>

</html>
