<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

   

    .slot-table th,.slot-table td {
        border: 1px solid #999999;
        padding: 6px;
        text-align: center;
    }
  

        .heading-slot-bg{
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')


<table width="100%">
    {{-- <tr>
        <td align="left"> <b>Shift:</b></td>
        <td align="left"><b> From Date:</b> {{$data['start_date'] ?? ""}}</td>
        <td align="left"><b> To Date:</b> {{$data['end_date'] ?? ""}}</td>
    </tr> --}}

</table>

<table class="slot-table" width="100%" cellspacing="0" border="0">
    <thead>
        <tr class="heading-slot-bg">
            <th>#</th>
            <th>Payment Method</th>
            <th>Account Name</th>
            <th>Account No.</th>
            <th>Amount</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($data['accont_amount_array'] as $index => $account_data)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $account_data['payment_method_name'] }}</td>
                <td>{{ $account_data['user_name'] }}</td>
                <td>{{ $account_data['gateway_account_no'] }}</td>
                <td style="text-align: right"><strong>{{ number_format($account_data['pay_amount'], 2) }}</strong></td>
            </tr>
        @endforeach

        @if ($data['total_amount'] > 0)
            <tr>
                <td colspan="4" style="text-align: right"><strong>Total Amount</strong></td>
                <td style="text-align: right"><strong>{{ number_format($data['total_amount'], 2) }}</strong></td>
            </tr>
        @endif
    </tbody>

</table>

</body>



<style>
   @page {
    size: A4 landscape; /* Set to A4 landscape */
    margin: 1px 0;
    }

    body {
        margin: 5px 20px 0;
        /* border: 1px dotted black; */
    }

   

</style>
</html>