<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

        .slot-table td {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            /*border-style: none;*/

        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')


<table width="100%">
    <tr>
        <td align="left"> <b>Shift:</b> {{$class_shift_details->shift_name ?? ""}}</td>
        <td align="left"><b> From Date:</b> {{$from_date ?? ""}}</td>
        <td align="left"><b> To Date:</b> {{$to_date ?? ""}}</td>
    </tr>

</table>

<table class="slot-table" width="100%" cellspacing="0" border="0">
    <thead style="background-color:  #e6e6e6;">
    <tr>

        <td  style="padding:2px; border: 1px solid black;"><b>Class</b></td>
        <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b>Generate Amount</b></td>
        <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b>Fine Amount</b></td>
        <td style="padding:2px; border: 1px solid black;" class="amount-right"><b>Waiver Amount</b></td>
        <td style="padding:2px; border: 1px solid black;" class="amount-right"><b>Payable Amount</b></td>
        <td align="center" style="padding:2px; border: 1px solid black;" class="amount-right"><b>Paid Amount</b></td>
        <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b>Due Amount</b></td>
    </tr>
    </thead>
    <tbody>


    @php($sl=1)
    @foreach($all_class_total_payment_list as $key=>$value)

        <tr>
            <td class="text-right" style="padding:2px; border: 1px solid black;">{{$value['class_name']}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$value['total_payable_amount']==0?"0.00":number_format($value['total_generate_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$value['total_fine_amount']==0?"0.00":number_format($value['total_fine_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$value['total_waiver_amount']==0?"0.00":number_format($value['total_waiver_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$value['total_payable_amount']==0?"0.00":number_format($value['total_payable_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$value['total_paid_amount']==0?"0.00":number_format($value['total_paid_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$value['total_due_amount']==0?"0.00":number_format($value['total_due_amount']).".00"}}</td>
        </tr>

    @endforeach


    </tbody>
    <tfoot  style="background-color:  #e6e6e6;">
    <tr>
        <td colspan="1" class="amount-left" style="border: 1px solid black;">Total</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_generate_amount==0? "0.00":$total_generate_amount.".00"}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_fee_fine_amnt==0?"0.00":$total_fee_fine_amnt.".00"}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_waiver_amount==0?"0.00":$total_waiver_amount.".00"}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_payable_amount==0? "0.00":$total_payable_amount.".00"}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_paid_amount==0?"0.00":$total_paid_amount.".00"}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_due_amount==0?"0.00":$total_due_amount.".00"}}</td>

    </tr>
    </tfoot>

</table>

{{--<table width="100%">--}}
    {{--<br>--}}
    {{--<tr>--}}
        {{--<td align="left">--}}
            {{--Print Date: {{date('d-m-Y h:i:s A',time())}}--}}
        {{--</td>--}}
    {{--</tr>--}}

{{--</table>--}}

</body>



<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        /*border:1px dotted black;*/
    }

</style>
</html>