<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ $title_view }}</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table {
            font-size: x-small;
            border-collapse: collapse;
            width: 100%;
        }
        .talbe tr th, .talbe tr td {
            border: 1px solid #999999;

            text-align: center;
        }
        .talbe tr th {
            background-color: #d1cbcb;
        }
        .talbe tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }
        .amount-right {
            text-align: right;
        }
        .gray-background {
            background-color: lightgray;
        }
    </style>
</head>
<body>

    @include('default.site.layout.pdf-header')

    <table class="table table-bordered talbe" style="margin-top: 20px">
        <thead>
            <tr>
                <th>SL</th>
                <th style="text-align: left;">Name</th>
                <th>Username</th>
                <th>Roll</th>
                @foreach ($siteBaseFeeList as $siteFee)
                    <th style="text-align: center;">
                        {{ $siteFee['academic_fee_sub_head']['name'] }}
                    </th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @if(count($siteStudentFeeList) > 0)
                @foreach ($siteStudentFeeList as $index => $student)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td style="text-align: left;">
                        <b>{{ $student['full_name'] }}</b>
                    </td>
                    <td><b>{{ $student['username'] }}</b></td>
                    <td><b>{{ $student['student_roll_number'] }}</b></td>

                    @foreach ($student['feeFinalList'] as $studentFee)
                        <td class="{{ $studentFee['demand_slip_create_status'] ? 'gray-background' : '' }}">
                            {{ $studentFee['generate_amount'] ?? '--' }}
                        </td>
                    @endforeach
                </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="{{ 4 + count($siteBaseFeeList) }}" class="no-data" style="color: red">Data isn't found</td>
                </tr>
            @endif
        </tbody>
    </table>

</body>

<style>
    @page {
        size: A4;
        margin: 20px;
    }
    body {
        margin: 20px;
    }
</style>
</html>
