<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>{{ $title_view }}</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }

        table {
            font-size: x-small;
            width: 100%;
            border-collapse: collapse;
        }

        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right {
            text-align: right;
        }

        .gray {
            background-color: lightgray;
        }

        .table-header {
            background-color: #b3dbff;
            font-weight: bold;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        table.payment-history-table th,
        table.payment-history-table td {
            border: 1px solid #ddd;
            padding: 5px;
        }

        ,
        td {
            border: 1px solid #ddd;
            padding: 5px;
        }

        table>th,
        td {
            border: none;
            padding: 5px;
        }
    </style>
</head>

<body>

    <div>
        @include('default.site.layout.pdf-header')

        <table class="payment-history-table" style="margin-top: 20px;">
            <thead>
                <tr class="table-header">
                    <th>#</th>
                    <th>Name</th>
                    <th class="text-center">Username</th>
                    <th class="text-center">Roll</th>
                    <th>Voucher No</th>
                    {{-- <th class="text-center">Pay Mode</th> --}}
                    <th class="text-center">Payment Date</th>
                    <th class="text-center">Payment Time</th>
                    <th class="text-right">Total Amount</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($payment_history_list as $index => $payment)
                    <tr>
                        <td class="text-center">{{ $index + 1 }}</td>
                        <td>{{ $payment['studentHistory']->full_name ?? 'N/A' }}</td>
                        <td class="text-center">{{ $payment['studentHistory']->username ?? 'N/A' }}</td>

                        <td class="text-center">{{ $payment['studentHistory']->student_full_roll_number ?? 'N/A' }}</td>
                        <td class="text-center">{{ $payment['voucher_no'] }}</td>
                        {{-- <td class="text-center">{{ $payment['sonali_pay_mode'] }}</td> --}}
                        <td class="text-center">{{ $payment['payment_date'] }} </td>
                        <td class="text-center"> {{ $payment['created_at'] }}</td>
                        <td class="text-right">{{ number_format($payment['paid_amount'], 2) }}</td>
                    </tr>

                @endforeach
                    <tr>
                        <td colspan="7" class="text-right">Total Amount</td>
                        <td class="text-right"><b>{{ number_format($total_amount, 2) }}</b></td>
                    </tr>
                @if ($payment_history_list->isEmpty())
                    <tr>
                        <td colspan="8" class="text-center" style="color: red">No data found</td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>

    <style>
        @page {
            size: A4;
            margin: 10px;
        }

        body {
            margin: 10px;
        }
    </style>

</body>

</html>
