<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>{{ $title_view }}</title>

    <style>
        @font-face {
            font-family: NikoshLightBan;
            src: url('{{ public_path('/public/fonts/NikoshLightBan.tff') }}');
        }

        body {
            /*font-family: Tahoma, Geneva, sans-serif;*/
        }


        .borderimg {
            position: fixed;
            top: 0;
            left: 0;

            /* Preserve aspet ratio */
            /*min-width: 100%;*/
            /*min-height: 100%;*/
        }

        .main-div {

            @if ($tc_setting->watermark_status)
                background-image: url({{ asset('/img/site/TC') . '/' . $tc_setting->watermark_image }});
                background-position: center center;
                background-size: cover;
                background-repeat: no-repeat;
            @endif

            background-color: {{ $tc_setting->testimonial_background_color ? $tc_setting->testimonial_background_color : 'white' }};

        }

        .name-style {
            font-weight: bold;
            text-align: center;
            border-bottom: 1px dotted black;
            display: inline-block;
            overflow: hidden;
            text-transform: uppercase;
        }

        .district {
            font-weight: bold;
            width: 150px;
            text-align: center;
            border-bottom: 1px dotted black;
            display: inline-block;
            overflow: hidden;
            text-transform: uppercase;
        }

        .rollreg {
            font-weight: bold;
            text-align: center;
            border-bottom: 1px dotted black;
            display: inline-block;
            overflow: hidden;
            text-transform: uppercase;
        }


        .testtext tr td {
            /*display: inline-block;*/
            text-align: justify;
            line-height: 2;
        }
    </style>

</head>

<body>

    <div>

        <div class="">
            @if ($tc_setting->border_image_status)
                <img class="borderimg" src="{{ asset('/img/site/TC') . '/' . $tc_setting->border_image }}" width="1120"
                    height="795">
            @endif
            <div class="main-div" style="padding: 70px;height: 600px;">

                <div style="text-align: center;">
                    <table width="100%;" border="0">
                        <tr>
                            <td style="width: 20%;">
                                @if ($tc_setting->logo_position == 'left')
                                    <img style="float: left;padding: 0;" src="{{ asset($site->site_logo) }}"
                                        width="90" height="85">
                                @endif
                            </td>
                            <td style="width: 60%; text-align: center; /*border: 1px solid green*/">
                                <div class="sitename"
                                    style="font-size: 22px;text-transform:uppercase; font-weight:bold; font-style: {{ $tc_setting->academic_name_font }}">
                                    {!! $site->site_name !!}</div>
                                <div style="font-size: 16px; font-style: {{ $tc_setting->academic_address_font }}">
                                    {!! $site->address !!}</div>
                            </td>
                            <td style="width: 20%;font-size: 10px;text-align: right;vertical-align: bottom;">

                                @if ($tc_setting->logo_position == 'left')
                                    @if ($tc_setting->eiin_show_status)
                                        <div style="font-size: 14px;"> EIIN: {!! $site->eiin !!}</div>
                                    @endif
                                    @if ($tc_setting->college_code_show_status)
                                        <div style="font-size: 14px;"> College Code: {!! $site->college_code !!}</div>
                                    @endif
                                    @if ($tc_setting->nu_code_show_status)
                                        <div style="font-size: 14px;"> NU Code: {!! $site->nu_code !!}</div>
                                    @endif
                                @endif

                            </td>
                        </tr>
                    </table>
                </div>
                @if ($tc_setting->logo_position == 'center')
                    <table>
                        <tr>
                            <td style="width: 300px;">

                            </td>
                            <td style="width: 325px">
                                <div style="text-align: center;">
                                    <img style="padding: 0;" src="{{ asset($site->site_logo) }}" width="90"
                                        height="85">
                                </div>
                            </td>
                            <td style="width: 300px;">

                                <div style="text-align:right; padding-right:100px">

                                    @if ($tc_setting->eiin_show_status)
                                        <div style="font-size: 14px;"> EIIN: {!! $site->eiin !!}</div>
                                    @endif
                                    @if ($tc_setting->college_code_show_status)
                                        <div style="font-size: 14px;"> College Code: {!! $site->college_code !!}</div>
                                    @endif
                                    @if ($tc_setting->nu_code_show_status)
                                        <div style="font-size: 14px;"> NU Code: {!! $site->nu_code !!}</div>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    </table>




                    <div style="margin-top:10px;">

                        <div style="text-align:center; font-style: {{ $tc_setting->title_font }}">
                            <label class="tittle" style="font-size: 19px;text-transform:uppercase;">
                                <span>{!! $report_tittle !!}</span>
                            </label>
                        </div>

                        <div style="font-style:{{ $tc_setting->ref_no_font }}">
                            <span>
                                Ref. No.:
                                <b>{{ $student_tc->referance_prefix }}</b>
                                <b>{{ $student_tc->referance_number }}</b>
                                <b>{{ $student_tc->referance_suffix }}</b>
                            </span>
                        </div>

                    </div>
                @endif

                <div
                    style="margin-top:30px;font-size:16px; width: 920px; font-style:{{ $tc_setting->description_font }}">
                    <table class="testtext" width="100%;" border="0">
                        <tr>
                            <td style="width: 100%;">

                                This is to certify that
                                <span class="name-style" style="width: 765px;">
                                    {{ $student_tc->studentHistory->full_name, $student_tc->studentHistory->student->father_name }}
                                </span>,
                                <br>

                                @if ($student_tc->studentHistory->student->gender->head_key == 'girls')
                                    <span>Daughter of</span>
                                @elseif($student_tc->studentHistory->student->gender->head_key == 'boys')
                                    <span>Son of</span>
                                @endif


                                <span class="name-style" style="width: 820px;">
                                    @if ($tc_setting->parents_title_status)
                                        <span>Mr. </span>
                                    @endif
                                    {{ $student_tc->studentHistory->student->father_name }}
                                </span>
                                <br>
                                and
                                <span class="name-style" style="width: 880px;">
                                    @if ($tc_setting->parents_title_status)
                                        <span>Mrs. </span>
                                    @endif
                                    {{ $student_tc->studentHistory->student->mother_name }}
                                </span>
                                <br>


                                was a student of this institution.

                                @if ($student_tc->studentHistory->student->gender->head_key == 'girls')
                                    <span>Her</span>
                                @elseif($student_tc->studentHistory->student->gender->head_key == 'boys')
                                    <span>His</span>
                                @endif

                                @if ($student_tc->studentHistory->year->year_name)
                                    Academic year is
                                    <b>{{ $student_tc->studentHistory->year->year_name }}</b>,
                                @endif

                                @if ($student_tc->studentHistory->stClass->class_name)
                                    class
                                    <b>{{ $student_tc->studentHistory->stClass->class_name }}</b>,
                                @endif


                                @if ($student_tc->studentHistory->classGroup)
                                    group
                                    <b> {{ $student_tc->studentHistory->classGroup->group_name }}</b>,
                                @endif

                                @if ($student_tc->studentHistory->student->student_roll_number)
                                    roll
                                    <b>{{ $student_tc->studentHistory->student->student_roll_number }}</b>,
                                @endif

                                @if ($student_tc->studentHistory->shift->shift_name)
                                    shift
                                    <b>{{ $student_tc->studentHistory->shift->shift_name }}</b> &
                                @endif


                                @if ($tc_setting->session_show_status)

                                    @if ($student_tc->studentHistory->session)
                                        session <b>{{ $student_tc->studentHistory->session->session_name }}</b>.
                                    @endif
                                @endif
                                @if ($student_tc->studentHistory->student->gender->head_key == 'girls')
                                    <span>She</span>
                                @elseif($student_tc->studentHistory->student->gender->head_key == 'boys')
                                    <span>He</span>
                                @endif
                                studied in this college till <b>{{ $student_tc->institute_left_date }}</b> and paid all
                                the dues upto that date.

                                @if ($student_tc->studentHistory->student->gender->head_key == 'girls')
                                    <span>She</span>
                                @elseif($student_tc->studentHistory->student->gender->head_key == 'boys')
                                    <span>He</span>
                                @endif
                                has returned all borrowed books/other resources. All the documents including

                                @if ($student_tc->studentHistory->student->gender->head_key == 'girls')
                                    <span>her</span>
                                @elseif($student_tc->studentHistory->student->gender->head_key == 'boys')
                                    <span>his</span>
                                @endif
                                originial marksheet, testimonial and reg. card have been returned to
                                @if ($student_tc->studentHistory->student->gender->head_key == 'girls')
                                    <span>her.</span>
                                @elseif($student_tc->studentHistory->student->gender->head_key == 'boys')
                                    <span>him.</span>
                                @endif
                                <br>

                            </td>
                        </tr>

                        <tr>
                            <td>
                                @if ($student_tc->studentHistory->student->gender->head_key == 'girls')
                                    <span>Her</span>
                                @elseif($student_tc->studentHistory->student->gender->head_key == 'boys')
                                    <span>His</span>
                                @endif
                                conduct as a student of this institution was satisfactory.

                            </td>
                        </tr>
                    </table>

                    <!-- His Date of Birth is
                    <label>1/1/2020</label> -->

                </div>



                @if ($tc_setting->logo_position == 'left')
                    <div style="margin-top:20px;">

                        <div style="margin-top:30px;text-align:center; font-style: {{ $tc_setting->title_font }}">
                            <label class="tittle" style="font-size: 19px;text-transform:uppercase;">
                                <span>{!! $report_tittle !!}</span>
                            </label>
                        </div>

                        <div style="font-style:{{ $tc_setting->ref_no_font }}">
                            <span>
                                Ref. No.:
                                <b>{{ $student_tc->referance_prefix }}</b>
                                <b>{{ $student_tc->referance_number }}</b>
                                <b>{{ $student_tc->referance_suffix }}</b>
                            </span>
                        </div>

                    </div>
                @endif




                @if ($tc_setting->logo_position == 'left')
                    <br>
                @endif

                <div style="margin-top:20px;font-size:14px;">
                    <table width="100%">
                        <tr>
                            <td style="text-align:left; font-style:{{ $tc_setting->print_data_font }}" width="65%">
                                @if ($tc_setting->written_by_show_status)
                                    <br><br>
                                    Written By :
                                    <br><br>
                                @endif
                                <br><br>
                                @if ($tc_setting->printed_date_show)
                                    Printed On: {{ date('d M Y', time()) }}
                                @endif
                            </td>
                            <td style="float: right;text-align:center;padding-right:35px;font-style: {{ $tc_setting->author_font }}""
                                width="50%">
                                <span>..............................</span><br>
                                <span>{{ $designation }}</span><br>
                                <span>{!! $site->site_name !!}</span> <br>
                                <span style="font-size:11px;">{!! $site->address !!}</span>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        {{-- <div style="page-break-after: always;page-break-inside:avoid;"></div> --}}


    </div>

</body>


<style>
    @page {
        size: Landscape;
        margin: 1px 0;
    }

    /*@page {*/
    /*size: a4;*/
    /*margin: 1px 0;*/
    /*}*/
    body {
        margin: 10px 15px 10px 20px;

    }
</style>

</html>
