<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        body {
            margin: 10px;
            padding: 5px;
        }

        .header-title {
            font-size: 20px;
            text-align: center;
            padding: 10px 0;
        }

        .logo {
            text-align: left;
            padding-top: 0px;
        }

        .center-header {
            text-align: center;
            padding-right: 100px;
        }

        .signature tr th,
        .signature tr td{
           border:none
        }
    </style>
</head>
<body>
    <div class="page">

        {{-- Header with logo and title --}}
            <div class="headerco" style="width: 100%;">
                <table style="width: 100%; border: none;">
                    <tr>
                        <td style="width: 10%; text-align: left; border: none;">
                            <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                                src="{!! public_path('img/site_group/logo/' . $SiteGroupInfo['group_logo']) !!}">
                        </td>
                        <td style="width: 100%; text-align: center; padding-right: 100px; border: none;">
                            <span style="font-size: 25px">{{ $SiteGroupInfo['name'] }}</span> <br>
                            <span style="font-size: 15px"> Education Department </span> <br>
                            <span style="font-size: 15px"> Inter College </span> <br>
                            <span style="font-size: 15px"> {{ $resultType->name }} 2025</span>
                            <span style="font-size: 14px"> Combined Merit list </span> <br>
                        </td>
                    </tr>
                </table>
            </div>

        {{-- Merit List Table --}}
        @php
            $meritList = $getSiteGroupPrimaryResultMeritListStatistics['merit_list'] ?? [];
        @endphp

        @if (count($meritList) > 0)
            <table>
                <thead style="background-color: #f2f2f2;">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Institute</th>
                        <th>Group</th>
                        <th>Class Roll</th>
                        <th>Central Roll</th>
                        <th>Total</th>
                        <th>%</th>
                        <th>Grade</th>
                        <th>Point</th>
                        <th>Rank</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($meritList as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item['student_name']}}</td>
                            <td>{{ $item['username']}}</td>
                            <td>{{ $item['site_name']}}</td>
                            <td>{{ $item['class_group']}}</td>
                            <td>{{ $item['class_roll']}}</td>
                            <td>{{ $item['central_roll']}}</td>
                            <td>{{ $item['total_mark']}}</td>
                            <td>{{ $item['mark_percentage']}}</td>
                            <td>{{ $item['grade']}}</td>
                            <td>{{ $item['gpa']}}</td>
                            <td>{{ $item['central_rank']}}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p style="text-align: center; padding: 20px;">No merit list data available.</p>
        @endif
    </div>

    <div style="margin-top:30px;">
        <table class="signature" width="100%">
            <tr>
                <th width="33%" style='float:left'>Counter Signature</th>
                <th width="33%"></th>
                <th width="33%"> </th>
            </tr>
        </table>
    </div>

    <div style="margin-top:50px;">

        <table class="signature" width="100%">
            <tr>
                <th width="33%">

                </th>
                <th width="33%">
                    <span>..............................</span><br>
                    <span>Member Secretary</span><br>
                    <span>Central Annual Exam Committee 2025</span>
                </th>

                <th width="33%">
                    <span>..............................</span><br>
                    <span>Convener</span> <br>
                    <span>Central Annual Exam Committee 2025</span>
                </th>
            </tr>
        </table>
    </div>
</body>

<style>
    @page {
        size: A4 protrait   ;
        margin: 10px;
    }
</style>
</html>
