<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        body {
            width: 800pt;
            height: 550pt;
            margin: 0;
            padding: 5px;
        }

        .site-name {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin-top: 10px;
        }
    </style>

</head>

<body>

    <div class="headerco" style="width: 100%;">
        <table style="width: 100%; border: none;">
            <tr>
                <td style="width: 10%; text-align: left; border: none;">
                    <img width="70" height="70" src="{!! public_path('uploads/' . $SiteGroupInfo['group_logo']) !!}">
                </td>
                <td style="width: 90%; text-align: center; border: none;">
                    <span style="font-size: 25px">{{ $SiteGroupInfo['name'] }}</span> <br>
                    <span style="font-size: 15px">Education Department</span>
                </td>
            </tr>
        </table>
    </div>

    @php
        // সাইট অনুযায়ী গ্রুপিং (একই পেজে)
        $sites = [];
        foreach($emp_array as $emp) {
            $site = $emp['site_name'] ?? 'Unknown Site';
            $sites[$site][] = $emp;
        }
    @endphp

    @foreach($sites as $siteName => $employees)
        <div class="site-name">{{ $siteName }}</div>

        <table>
            <thead>
                <tr>
                    <th>Serial</th>
                    <th>Name</th>
                    <th>Designation</th>
                </tr>
            </thead>
            <tbody>
                @foreach($employees as $key => $emp)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $emp['full_name'] }}</td>
                        <td>{{ $emp['designation'] }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        <!-- page-break সরানো হয়েছে -->
    @endforeach

</body>

<style>
    @page {
        size: A4 landscape;
        margin: 10px;
    }
</style>

</html>
