
@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
    {!! Html::style('datepicker/css/datepicker.css') !!}
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-6">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>
                        {{ trans('sidebar.edit_student') }}
                    </div>
                    <div class="col-md-6 col-xs-6 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('sidebar.dashboard') }}</a></li>
                            <li class="active">
                           {{ trans('sidebar.edit_student') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-view">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">

                    @if (count($errors) > 0)
                        <div class="alert alert-danger row">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if(session()->has('success'))
                        <div class="alert alert-success row">
                            <ul>

                                <li>{{ session()->get('success') }}</li>

                            </ul>
                        </div>
                    @endif

                   <div class="custom_row">
                        {!! inputLangControl() !!}
                    </div>

                    <div class="custom_row">                      
                        <h2 class="form_title">
                            {{ trans('sidebar.edit_student') }}
                        </h2>                                          
                    </div>



                        <div class="col-md-12" hidden id="divImage" style="text-align:center; background-color: whitesmoke;">

                            <img class="img-responsive img-thumbnail" src="#" id="dImg" style="text-align:center; padding: 10px;" />

                        </div>

                        <div class="col-md-12"  id="WhenNewPicEditShow" style="text-align:center; background-color: whitesmoke;">

{{--                            <img class="img-responsive img-thumbnail" src="/uploads/{{$studentProfile}}"  id="dImg" style="text-align:center; padding: 10px;" />--}}
                            @if( count($studentProfile->photos)>0)
                                {!!  Html::image('uploads/'.$studentProfile->photos->last()->name, 'alt', array( 'width' => 120, 'height' => 120,'class' => 'img-rounded' )) !!}
                            @else
                            @endif
                        </div>



                    {!! Form::model(
                                $studentProfile,
                                array(
                                'route' => ['student-edit',$studentProfile->id],
                                'files' => true,
                                'id'=>'create-form',
                                'class'=>'form-create',
                                'method'=>'PATCH'
                                ))
                    !!}

                    {!! formFields($editStudent,$mode='edit',$studentProfile->id)  !!}

                    {!!  Form::close()   !!}

                </div>
            </div>
        </div>
    </div>



@endsection
@section('scripts')


    @parent

    {{-- <script src="{{ asset('jquery-validation/dist/jquery.validate.min.js') }}"></script>--}}
    {!! Html::script('datepicker/js/bootstrap-datepicker.js') !!}
    {!! Html::script('select/js/select2.min.js') !!}

    <script type="text/javascript">
        $(document).ready(function(){
            function formatData (data) {
                if (!data.id) { return data.text; }
                /*  if (data.element) {
                 console.log($(data.element).attr("data-img"));
                 }*/
                var img=$(data.element).attr("data-img");
                var $result;
                if(data.id==0){
                    $result= $('<span>' + data.text + '</span>');
                }else {
                    $result= $('<span><img height="50" width="50"  class="img-rounded" src="/uploads/'+img+'"/> ' +
                            data.text +
                            '</span>');
                }
                return $result;
            }

            $("#guardian_id").select2({
                // placeholder: "Select something!!",
                width: "50%",
                allowClear: true,
                templateResult: formatData,
                templateSelection: function (option) {
                    console.log('55'+option.id)
                    if (option.id.length > 0 && option.id>0) {
                        return option.text + " <i class='fa fa-check'></i>";
                    } else {
                        return option.text;
                    }
                },
                escapeMarkup: function (m) {
                    return m;
                }
            });

            $('#gender_id').select2();
            $('#religion_id').select2();
            $('#department_id').select2();
            $('#student_class_id').select2();
            $('#section_id').select2();
            $('#subject_group_id').select2();
            /* start date picker option*/
            //$('#birthday').datepicker() ;

            $('#birthday').datepicker({
                format: 'yyyy-mm-dd',
            }).on('changeDate', function(e){
                $(this).datepicker('hide');
            });


            $('#dept_join_date').datepicker({
                format: 'yyyy-mm-dd',
            }).on('changeDate', function(e){
                $(this).datepicker('hide');
            });

            //$('#dept_join_date').datepicker() ;
            /* end date picker option*/

            /*start choose section onchange event of class*/
            $('#student_class_id').change(function(){
                var host = window.location.origin ;
                var studentClassId = $('#student_class_id').find('option:selected').val();
                $.ajax({
                    'url': host + '/student-class/' + studentClassId,
                    'dataType': 'json'
                }).success(function (data) {
//                    console.log(data);
                    var sectionForClass = "<option value=''>Select Section</option>";
                    $(data[0]).each(function(index,item){
                        sectionForClass += "<option value ="+ item.id +">"+item.section_name+" </option>";
                    });
                    $('#section_id').html(sectionForClass);

                    var subjectGroupForClass = "<option value=''>Select Subject Group</option>";
                    $(data[2]).each(function(index,item){
                        subjectGroupForClass += "<option value ="+ item.id +">"+item.subject_group_name+" </option>";
                    });
                    $('#subject_group_id').html(subjectGroupForClass);
                })
            });
            /*end choose section onchange event of class*/

            /*------------show image-------------*/

            $("#file").change(function () {

                console.log("ok");

                if (this.files && this.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function (e) {

                        $('#WhenNewPicEditShow').hide();
                        $('.error').hide();
                        $('#divImage').show();
                        $('#dImg').show();
                        $('#dImg')
                                .attr('src', e.target.result)
                                .width(150)
                                .height(150).css("z-index", "100");
                    };

                    reader.readAsDataURL(this.files[0]);
                }
            });


            /*------------end show image-------------*/



            /*start get selected designation for selected department*/


            var userId = "<?php echo $studentProfile->id; ?> "

            var host = window.location.origin ;

            $.ajax({
                'url': host + '/designation/user/'+userId,
                'dataType': 'json'
            }).success(function (data) {

                var designationsForDepartment = "<option value="+data.id + ">"+data.name+" </option>";

                $('#designation_id').html(designationsForDepartment);
            })

            /*start get selected designation for selected department*/


            /*start choose designation onchange event of department*/

            $('#department_id').change(function(){

                var host = window.location.origin ;

                var departmentId = $('#department_id').find('option:selected').val();

                $.ajax({
                    'url': host + '/designation/' + departmentId,
                    'dataType': 'json'
                }).success(function (data) {

                    var designationsForDepartment = "<option value=''>Select </option>";
                    var shiftsForDepartment = "<option value=''>Select </option>";

                    $(data[0]).each(function(index,item){

                        designationsForDepartment += "<option value ="+ item.id +">"+item.name+" </option>";
                    });
                    $('#designation_id').html(designationsForDepartment);
                    $(data[1]).each(function(index,item){

                        shiftsForDepartment += "<option value ="+ item.id +">"+item.name+" </option>";
                    });
                    $('#shift_id').html(shiftsForDepartment);
                })



            });

            /*end choose designation onchange event of department*/




            /*---------------- onchange event for image------------------*/

            $('#guardian_id').change(function(){
                var host = window.location.origin ;
                var gurdianImageId = $('#guardian_id').find('option:selected').val();
                //console.log('df'+gurdianImageId);
                if(gurdianImageId==0) {
                    $('#guardianImg').html('');
                    return;
                };
                $.ajax({
                    'url': host + '/guardian/guardian-by-id/' + gurdianImageId,
                    'dataType': 'json'
                }).success(function (data) {

                    console.log(data);
                    var imageForGuaardian = new  Array();
                    var obj = Object.keys(data)
                    imageForGuaardian += "<img src='/imagecache/dummy/" +obj+ "'/>"
                    $('#guardianImg').html(imageForGuaardian);

                });

            });

        });
    </script>

@endsection